<?php
//////////////////////////////////////////////////
// WordPress Theme Primitive 1.0 by Buzzlyhan
//////////////////////////////////////////////////

//////////////////////////////////////////////////
// wp_head()によりheadタグ内に
// style.css 読み込み
// reset.css 読み込み  
// mystyle.css 読み込み 
//////////////////////////////////////////////////
function my_theme_css() {
	wp_enqueue_style( 'main-style', get_stylesheet_uri() );
    wp_enqueue_style( 'reset-style', get_template_directory_uri().'/css/reset.css' );
	wp_enqueue_style( 'my-style', get_template_directory_uri().'/css/mystyle.css' );
}
add_action( 'wp_enqueue_scripts', 'my_theme_css' );

//////////////////////////////////////////////////
// wp_head()によりheadタグ内に
// タイトルを出力
//////////////////////////////////////////////////
add_theme_support( 'title-tag' );


//////////////////////////////////////////////////
// テーマカスタマイザー内に
// 文字色変更表示　文字色変更のスタイルタグを出力
//////////////////////////////////////////////////
function wphead_cb() {
	echo '<style type="text/css">';
	echo 'body { color: #'.get_header_textcolor().' }';
	echo '</style>';
}

$custom_header_args = array(
	'default-text-color' => '000',
	'wp-head-callback' => 'wphead_cb'
);
add_theme_support( 'custom-header', $custom_header_args );


//////////////////////////////////////////////////
// テーマカスタマイザー内に
// ヘッダー画像カスタマイズ表示
//////////////////////////////////////////////////
$custom_header = array(
	'width'         => 980,
	'height'        => 100,
	'default-image' => get_template_directory_uri() . '/images/header.png',
	'uploads'       => true,
);
add_theme_support( 'custom-header', $custom_header );

//////////////////////////////////////////////////
// メニューカスタマイズ
//////////////////////////////////////////////////
function my_menu(){
    register_nav_menus(array(
    'header-nav' => ' ヘッダーナビ ',
    'footer-nav' => ' フッターナビ ',
    ));
 }
 add_action('after_setup_theme','my_menu');

//////////////////////////////////////////////////
// ウィジェットカスタマイズ
//////////////////////////////////////////////////
function my_header_widget() {
    register_sidebar( array(
    'name' => 'ヘッダーウィジェット ',
    'id' => 'header-widget',
    'description' => ' これはヘッダーウィジェットです ',
    'before_widget' => '<div id="header-widget_%1$s" class="header-widget_%2$s">',
    'after_widget' => '</div>',
    'before_title' => '<h2 class="header-widget_title">',
    'after_title' => '</h2>',
    ) );
}
add_action( 'widgets_init', 'my_header_widget' );

function my_sidebar_widget() {
    register_sidebar( array(
    'name' => ' サイドバーウィジェット ',
    'id' => 'sidebar-widget',
    'description' => ' これはサイドバーウィジェットです ',
    'before_widget' => '<div id="sidebar-widget_%1$s" class="sidebar-widget_%2$s">',
    'after_widget' => '</div>',
    'before_title' => '<h2 class="sidebar-widget_title">',
    'after_title' => '</h2>',
    ) );
}
add_action( 'widgets_init', 'my_sidebar_widget' );


