bl_info = {
    "name": "Mouse Render Trigger",
    "author": "buzzlyhan",
    "version": (1, 0),
    "blender": (4, 2, 0),
    "location": "View3D > Operator Search > Modal Render Trigger",
    "description": "Trigger render with mouse actions",
    "category": "Render",
}

import bpy

class ModalRenderOperator(bpy.types.Operator):
    bl_idname = "wm.modal_render_operator"
    bl_label = "Modal Render Trigger"
    _timer = None
    
    def modal(self, context, event):
        # デバッグ情報
        print(f"Event: {event.type} ({event.value})")
        
        # 左マウスボタンリリース
        if event.type == 'LEFTMOUSE' and event.value == 'RELEASE':
            print("Left mouse released - rendering")
            bpy.ops.render.render('INVOKE_DEFAULT')
            return {'RUNNING_MODAL'}
            
        # マウスホイール上回転
        # elif event.type == 'WHEELUPMOUSE' and event.value == 'PRESS':
        #     print("Mouse wheel up - rendering")
        #     bpy.ops.render.render('INVOKE_DEFAULT')
        #     return {'RUNNING_MODAL'}
            
        # マウスホイール中クリック
        elif event.type == 'MIDDLEMOUSE' and event.value == 'RELEASE':
            print("Middle mouse released - rendering")
            bpy.ops.render.render('INVOKE_DEFAULT')
            return {'RUNNING_MODAL'}
        
        # ESCキーで終了
        if event.type == 'ESC':
            print("Exiting Modal")
            self.cancel(context)
            return {'CANCELLED'}
            
        return {'PASS_THROUGH'}

    def execute(self, context):
        wm = context.window_manager
        self._timer = wm.event_timer_add(0.1, window=context.window)
        wm.modal_handler_add(self)
        print("Modal Started")
        return {'RUNNING_MODAL'}

    def cancel(self, context):
        wm = context.window_manager
        wm.event_timer_remove(self._timer)
        print("Modal Cancelled")

# Register
classes = (ModalRenderOperator,)

def register():
    for cls in classes:
        bpy.utils.register_class(cls)

def unregister():
    for cls in classes:
        bpy.utils.unregister_class(cls)

if __name__ == "__main__":
    register()
