"""多言語化（i18n）用辞書定義
ソースコード（英語）から日本語への翻訳マップ
"""
import bpy
raw_data = {
    "Auto Update": "全更新",
    "* Synchronize all objects automatically": "※全オブジェクトを同期更新します",
    "* Real-time update for selected objects only": "※選択中のオブジェクトのみリアルタイム更新",
    "* Synchronize all toon settings": "※全てのトゥーン設定を同期します",
    "Apply / Update:": "適用/更新:",
    "Apply to Selected": "選択に適用",
    "Apply to All": "全てに適用",
    "Remove from Selected": "選択から削除",
    "Apply Toon Shader to selected mesh objects": "選択中のメッシュにトゥーンシェーダーを適用",
    "Apply Toon Shader to all mesh objects in the scene": "シーン内の全メッシュにトゥーンシェーダーを適用",
    "Remove Toon Shader from selected objects": "選択中のオブジェクトからトゥーンシェーダーを削除",
    "Create a vertex group to control outline thickness": "主線の太さ制御用の頂点グループを作成",
    "Update": "更新",
    "OMOSEN+ [Basic Settings]": "OMOSEN+ [基本設定]",
    "Mode": "モード",
    "* All objects will share the same material": "※全オブジェクトが同じマテリアルになります",
    "* Create new material while preserving textures": "※テクスチャを保持して新規作成します",
    "* Insert nodes into existing materials": "※既存マテリアルにノードを追加します",
    "Shared Material": "共通マテリアル",
    "Preserve Textures": "テクスチャ保持",
    "Insert Nodes (Non-destructive)": "ノード挿入（非破壊）",
    "Insert Nodes": "ノード挿入",
    "OMOSEN+ [Presets]": "OMOSEN+ [プリセット]",
    "Custom": "カスタム",
    "Anime Style": "アニメ風",
    "Game Style": "ゲーム風",
    "Manga Style": "マンガ風",
    "Preset": "プリセット",
    "Style preset": "スタイルプリセット",
    "Custom settings": "カスタム設定",
    "Sharp shadows": "くっきりした影",
    "Soft shadows": "柔らかい影",
    "Thick outlines, 3 shadow steps": "濃いアウトライン・3段階の影",
    "OMOSEN+ [Outline Settings]": "OMOSEN+ [主線設定]",
    "Thickness": "太さ",
    "Color": "色",
    "Outline Offset": "輪郭線の表示位置",
    "Auto Set": "自動設定",
    "Material Offset": "マテリアルオフセット",
    "* Adjust when multiple materials exist": "※複数マテリアルがある場合に調整",
    "Control Thickness by Part": "部位別の太さ制御",
    "Line Thickness Adjustment": "線の太さ調整",
    "Create Control Vertex Group": "制御用頂点グループを作成",
    "* After creation, adjust thickness via Weight Paint": "※作成後、ウェイトペイントで太さを調整可能",
    "Vertex Group": "頂点グループ",
    "OMOSEN+ [Inner Line Settings]": "OMOSEN+ [内線設定]",
    "Free Drawing": "自由な描き込み",
    "Line Drawing": "線の描き込み",
    "Create Drawing Pen": "描き込み用ペンを作成",
    "* Draw directly on the mesh surface": "※メッシュの表面に直接描けます",
    "Line Art (Viewport)": "Line Art（ビューポート）",
    "Real-time Preview": "リアルタイムプレビュー",
    "Freestyle (Render)": "Freestyle（レンダリング）",
    "High Quality Rendering": "高品質レンダリング",
    "Line Thickness": "ライン太さ",
    "Line Color": "ライン色",
    "Show edge lines in viewport (real-time)": "ビューポートでエッジライン表示（リアルタイムプレビュー用）",
    "High-quality lines during rendering (Freestyle)": "レンダリング時のライン描画（Freestyle）",
    "Enable Line Art": "Line Art有効",
    "Enable Freestyle": "Freestyle有効",
    "OMOSEN+ [Shading Settings]": "OMOSEN+ [影設定]",
    "Shadow steps": "段階数",
    "Interpolation": "補間方法",
    "Constant (Stepped)": "くっきり（階段状）",
    "Linear": "滑らか（線形）",
    "Ease (Very Smooth)": "非常に滑らか",
    "Method": "方式",
    "Lighting (Eevee)": "ライト反映 (Eevee専用)",
    "Vector Control (Cycles/Eevee)": "ベクトル制御 (Cycles/Eevee)",
    "Light Direction": "ライト方向",
    "Sunlight Sync": "サンライト同期",
    "Shadow Step": "影の範囲",
    "Shadow Range": "影の範囲",
    "Shadow Hardness": "影の硬さ",
    "Shadow Strength": "影の強さ",
    "Use Specular": "鏡面ハイライト有効",
    "Specular Size": "ハイライトサイズ",
    "Specular Color": "ハイライト色",
    "Use Rim Light": "リムライト有効",
    "Rim Light Color": "リムライト色",
    "Rim Light Strength": "リムライト強度",
    "Rim Light Width": "リムライト幅",
    "Shadow Color 1": "影色1",
    "Shadow Color 2": "影色2",
    "Light Boost": "ライト強度補正",
    "Light Mix (Cycles)": "ライト混合 (Cycles)",
    "Blend real lights with toon result": "ライトの影響をトゥーン結果に混合",
    "Shadow calculation method (for Cycles compatibility)": "影の計算方法（Cycles互換性のため）",
    "Directly reflect scene lights": "シーンのライトを直接反映（Shader to RGB使用）",
    "Calculate as light from a specific direction": "指定した方向からのライトとして計算（内積使用）",
    "Material Mode": "マテリアルモード",
    "Material application method": "マテリアルの適用方法",
    "OMOSEN+ [Render Settings]": "OMOSEN+ [レンダー設定]",
    "One-click Setup:": "ワンクリック設定:",
    "Set Render to Match Viewport": "見た目通りにレンダリング設定",
    "Description:": "説明:",
    "Automatically adjusts these settings:": "以下の設定を自動調整します:",
    "- Color Management: Standard": "・カラーマネジメント: Standard",
    "- Eevee: Soft Shadows OFF": "・Eevee: ソフトシャドウOFF",
    "- Eevee: Ambient Occlusion OFF": "・Eevee: アンビエントオクルージョンOFF",
    "- Eevee: Bloom OFF": "・Eevee: ブルームOFF",
    "- Eevee: Shadow Resolution UP": "・Eevee: 影の解像度UP",
    "Tip: For perfect flat shading": "ヒント: 完璧な「ベタ塗り」にするには",
    "- Set Light Size/Angle to 0": "・ライトの「サイズ/角度」を0にする",
    "- Increase Shadow Hardness to 100+": "・「影の硬さ」を100以上に上げる",
    "- Set Color Management to Standard": "・カラーマネジメントを「Standard」にする",
    "  (Render Properties > Color Management)": "　(レンダープロパティ > カラーマネジメント)",
    "OMOSEN+ [System Settings]": "OMOSEN+ [システム]",
    "Custom Presets (Asset)": "カスタムプリセット (Asset)",
    "Apply Selected Preset": "選択したプリセットを適用",
    "Export / Import Settings": "設定の書き出し・読み込み",
    "Save": "保存",
    "Load": "読み込み",
    "Save Current Settings": "現在の設定を保存",
    "Remove Preset": "プリセットを削除",
    "Apply Preset": "プリセットを適用",
    "Automatically update materials on change": "パラメータ変更時に自動的にマテリアルを更新",
    "Export Settings": "設定を保存",
    "Import Settings": "設定を読み込み",
    "Preset Name": "プリセット名",
    "Active Preset": "アクティブプリセット",
    "Save all current parameters as a new preset": "現在の全てのパラメータを新しいプリセットとして登録します",
    "Remove the selected preset": "選択中のプリセットを削除します",
    "Apply the selected preset to the scene": "選択中のプリセットをシーンに適用します",
    "Export current settings as a JSON file": "現在のパラメータ設定をJSONファイルとして保存",
    "Import settings from a JSON file": "JSONファイルからパラメータ設定を読み込み",
    "System Management": "システム管理",
    "Reset All Settings": "全設定を初期化",
    "Clear All Presets": "プリセットを全削除",
    "Load from Active": "選択から設定を読込",
    "Settings loaded from object": "オブジェクトから設定を読み込みました",
    "Applied to {} objects": "{}個のオブジェクトに適用",
    " ({} materials converted)": "（{}個のマテリアルを変換）",
    "No applicable mesh objects selected": "適用可能なメッシュオブジェクトが選択されていません",
    "No applicable mesh objects found": "適用可能なメッシュオブジェクトがありません",
    "Please select a mesh object": "メッシュオブジェクトを選択してください",
    "Removed from {} objects": "{}個のオブジェクトから削除しました",
    " ({} materials restored)": "（{}個のマテリアルを復元）",
    "No target found to remove": "削除対象が見つかりませんでした",
    "Created vertex group '{}' in {} objects": "{}個のオブジェクトに頂点グループ '{}' を作成しました",
    "Applied settings: {}": "設定を適用: {}",
    "All settings are already optimized": "すべての設定は既に最適化されています",
    "Failed to switch mode. Please switch manually.": "ドローモードへの自動切替に失敗しました。手動で切り替えてください。",
    "Drawing mode started (Esc to end)": "描き込みモードを開始しました（Escで終了）",
    "Settings saved: {}": "設定を保存しました: {}",
    "Settings loaded: {}": "設定を読み込みました: {}",
    "Preset '{}' saved": "プリセット '{}' を保存しました",
    "Preset '{}' removed": "プリセット '{}' を削除しました",
    "Preset '{}' applied": "プリセット '{}' を適用しました",
    "No preset found to apply": "適用するプリセットが見つかりませんでした",
    "Failed to save settings": "設定の保存に失敗しました",
    "Failed to load settings": "設定の読み込みに失敗しました",
    "Thickness of the outline": "アウトラインの太さ",
    "Color of the outline": "アウトラインの色",
    "Boundary position between shadow and highlight": "影とハイライトの境界位置",
    "Shadow color (midtone shadow)": "影の色（中間影）",
    "Deeper shadow color": "より深い影の色（3段階時のみ）",
    "Color of the highlighted parts": "明るい部分の色",
    "Number of shadow steps (2 or 3)": "影の段階数（2段 or 3段）",
    "Smoothness of shadow boundaries": "影の境界の滑らかさ",
    "Distinct boundary like toon shaders": "トゥーンシェーダー風の明確な境界",
    "Smooth gradient with linear interpolation": "線形補間で滑らかなグラデーション",
    "Natural gradient with easing interpolation": "イージング補間で自然なグラデーション",
    "Shadow boundary sharpness": "影の境界のパキパキ感（高いほど硬い。1000でほぼ二値化）",
    "Shadow opacity (0 to 1)": "影の不透明度（0で影なし、1で全開）",
    "Show sharp highlights": "パキッとした艶（ハイライト）を表示",
    "Size of the highlight": "ハイライトの大きさ",
    "Color of the highlight (usually white)": "ハイライトの色（通常は白）",
    "Add rim light or shadow around edges": "キャラクターの縁に光（または影）を追加",
    "Color of the rim light": "リムライトの色",
    "Brightness of the rim light": "リムライトの明るさ",
    "Spread of the rim light": "リムライトが広がる範囲",
    "Light direction for vector control": "ベクトル制御モード時の光の方向",
    "Sync with sunlight rotation using drivers": "シーン内のサンライトの回転と同期させる（ドライバー使用）",
    "Light boost for Cycles": "Cycles向けのライト強度補正（暗い場合に調整）",
    "* Auto: adjusts display order automatically": "※自動: 表示順を自動調整",
    "* Manual: use Material Offset to fix overlaps": "※手動: マテリアルオフセットで重なりを調整",
    "* On: Line Art preview in viewport": "※ON: ビューポートでLine Artをプレビュー",
    "* On: Freestyle lines in final render": "※ON: レンダーでFreestyle線を出力",
    "* Light Boost: overall light intensity": "※ライト強度補正: 全体の明るさ",
    "* Shadow Strength: darkness of shadows": "※影の強さ: 影の濃さ",
    "Highlight Color": "ハイライト色",
    "Automatically set material offset": "マテリアルオフセットを自動的に設定（推奨）",
    "Material slot index for manual setting": "アウトラインマテリアルのスロット番号（手動設定時）",
    "Vertex group name for partial outline": "アウトライン用の頂点グループ名（指定すると部分的にアウトライン適用）",
    "Create a grease pencil object for drawing on mesh surface": "メッシュ表面に描画できるグリースペンシルを作成",
    "Toggle real-time edge line display in viewport": "ビューポートのエッジライン表示を切り替え",
    "Toggle high-quality line rendering (Freestyle)": "Freestyleのライン描画を切り替え",
    "Export current settings as a JSON file": "現在の設定をJSONとして書き出し",
    "Import settings from a JSON file": "JSONから設定を読み込み",
    "Read toon settings from the active object into the UI": "選択オブジェクトの設定をUIに読み込み",
    "Apply settings to make render result match viewport": "ビューポートの見た目にレンダー設定を合わせる",
    "Current Render Engine: {}": "現在のレンダーエンジン: {}",
    "⚠ Cycles support is in development": "⚠ Cycles対応は開発中です",
    "Use 'Vector Control' shading mode for Cycles": "Cyclesでは「ベクトル制御」を使用してください",
}
zh_data = {
    "Auto Update": "自动更新",
    "* Synchronize all objects automatically": "※自动同步更新所有对象",
    "* Real-time update for selected objects only": "※仅对选中对象实时更新",
    "* Synchronize all toon settings": "※同步所有卡通设置",
    "Apply / Update:": "应用/更新:",
    "Apply to Selected": "应用到选中",
    "Apply to All": "应用到全部",
    "Remove from Selected": "从选中移除",
    "Update": "更新",
    "Apply Toon Shader to selected mesh objects": "将卡通着色器应用到选中的网格",
    "Apply Toon Shader to all mesh objects in the scene": "将卡通着色器应用到场景中的所有网格",
    "Remove Toon Shader from selected objects": "从选中对象移除卡通着色器",
    "Create a vertex group to control outline thickness": "创建用于控制轮廓线宽的顶点组",
    "OMOSEN+ [Basic Settings]": "OMOSEN+ [基本设置]",
    "Mode": "模式",
    "* All objects will share the same material": "※所有对象共享同一材质",
    "* Create new material while preserving textures": "※保留纹理并创建新材质",
    "* Insert nodes into existing materials": "※在现有材质中插入节点",
    "Shared Material": "共享材质",
    "Preserve Textures": "保留纹理",
    "Insert Nodes (Non-destructive)": "插入节点（非破坏）",
    "Insert Nodes": "插入节点",
    "OMOSEN+ [Presets]": "OMOSEN+ [预设]",
    "Custom": "自定义",
    "Anime Style": "动画风",
    "Game Style": "游戏风",
    "Manga Style": "漫画风",
    "Preset": "预设",
    "Style preset": "风格预设",
    "Custom settings": "自定义设置",
    "Sharp shadows": "硬边阴影",
    "Soft shadows": "柔和阴影",
    "Thick outlines, 3 shadow steps": "粗轮廓线，3段阴影",
    "OMOSEN+ [Outline Settings]": "OMOSEN+ [轮廓线设置]",
    "Thickness": "粗细",
    "Color": "颜色",
    "Outline Offset": "轮廓线显示位置",
    "Auto Set": "自动设置",
    "Material Offset": "材质偏移",
    "* Adjust when multiple materials exist": "※存在多个材质时需调整",
    "Control Thickness by Part": "按部位控制粗细",
    "Create Control Vertex Group": "创建控制用顶点组",
    "* After creation, adjust thickness via Weight Paint": "※创建后通过权重绘制调整粗细",
    "Vertex Group": "顶点组",
    "Line Thickness Adjustment": "线宽调整",
    "OMOSEN+ [Inner Line Settings]": "OMOSEN+ [内线设置]",
    "Free Drawing": "自由绘制",
    "Line Drawing": "线条绘制",
    "Create Drawing Pen": "创建绘制笔",
    "* Draw directly on the mesh surface": "※可直接在网格表面绘制",
    "Line Art (Viewport)": "Line Art（视口）",
    "Real-time Preview": "实时预览",
    "Freestyle (Render)": "Freestyle（渲染）",
    "High Quality Rendering": "高质量渲染",
    "Line Thickness": "线条粗细",
    "Line Color": "线条颜色",
    "Show edge lines in viewport (real-time)": "在视口显示边线（实时）",
    "High-quality lines during rendering (Freestyle)": "渲染时高质量线条（Freestyle）",
    "Enable Line Art": "启用Line Art",
    "Enable Freestyle": "启用Freestyle",
    "OMOSEN+ [Shading Settings]": "OMOSEN+ [阴影设置]",
    "Shadow steps": "阴影段数",
    "Interpolation": "插值方式",
    "Constant (Stepped)": "阶梯（硬边）",
    "Linear": "线性",
    "Ease (Very Smooth)": "缓和（更平滑）",
    "Method": "方式",
    "Lighting (Eevee)": "光照反映（Eevee）",
    "Vector Control (Cycles/Eevee)": "向量控制（Cycles/Eevee）",
    "Light Direction": "光方向",
    "Sunlight Sync": "同步太阳光",
    "Shadow Step": "阴影范围",
    "Shadow Range": "阴影范围",
    "Shadow Hardness": "阴影硬度",
    "Shadow Strength": "阴影强度",
    "Use Specular": "启用高光",
    "Specular Size": "高光大小",
    "Specular Color": "高光颜色",
    "Use Rim Light": "启用轮廓光",
    "Rim Light Color": "轮廓光颜色",
    "Rim Light Strength": "轮廓光强度",
    "Rim Light Width": "轮廓光宽度",
    "Shadow Color 1": "阴影色1",
    "Shadow Color 2": "阴影色2",
    "Light Boost": "光照强度补正",
    "Light Mix (Cycles)": "光照混合（Cycles）",
    "Blend real lights with toon result": "将真实灯光与卡通结果混合",
    "Shadow calculation method (for Cycles compatibility)": "阴影计算方式（Cycles兼容）",
    "Directly reflect scene lights": "直接反映场景灯光",
    "Calculate as light from a specific direction": "按指定方向的光进行计算",
    "Material Mode": "材质模式",
    "Material application method": "材质应用方式",
    "OMOSEN+ [Render Settings]": "OMOSEN+ [渲染设置]",
    "One-click Setup:": "一键设置:",
    "Set Render to Match Viewport": "渲染设置与视口一致",
    "Description:": "说明:",
    "Automatically adjusts these settings:": "自动调整以下设置:",
    "- Color Management: Standard": "・色彩管理: Standard",
    "- Eevee: Soft Shadows OFF": "・Eevee: 软阴影 关",
    "- Eevee: Ambient Occlusion OFF": "・Eevee: 环境光遮蔽 关",
    "- Eevee: Bloom OFF": "・Eevee: Bloom 关",
    "- Eevee: Shadow Resolution UP": "・Eevee: 阴影分辨率 提高",
    "Tip: For perfect flat shading": "提示: 完美平涂",
    "- Set Light Size/Angle to 0": "・将灯光尺寸/角度设为0",
    "- Increase Shadow Hardness to 100+": "・将阴影硬度提高到100以上",
    "- Set Color Management to Standard": "・色彩管理设为Standard",
    "  (Render Properties > Color Management)": "  (渲染属性 > 色彩管理)",
    "OMOSEN+ [System Settings]": "OMOSEN+ [系统]",
    "Custom Presets (Asset)": "自定义预设 (资产)",
    "Apply Selected Preset": "应用选中的预设",
    "Export / Import Settings": "导出/导入设置",
    "Save": "保存",
    "Load": "读取",
    "Save Current Settings": "保存当前设置",
    "Remove Preset": "删除预设",
    "Apply Preset": "应用预设",
    "Automatically update materials on change": "参数变更时自动更新材质",
    "Export Settings": "导出设置",
    "Import Settings": "导入设置",
    "Preset Name": "预设名",
    "Active Preset": "活动预设",
    "Save all current parameters as a new preset": "将当前所有参数保存为新预设",
    "Remove the selected preset": "删除选中的预设",
    "Apply the selected preset to the scene": "将选中的预设应用到场景",
    "Export current settings as a JSON file": "将当前设置导出为JSON文件",
    "Import settings from a JSON file": "从JSON文件导入设置",
    "System Management": "系统管理",
    "Reset All Settings": "重置全部设置",
    "Clear All Presets": "清空全部预设",
    "Load from Active": "从选中读取设置",
    "Settings loaded from object": "已从对象读取设置",
    "Applied to {} objects": "已应用到{}个对象",
    " ({} materials converted)": "（转换了{}个材质）",
    "No applicable mesh objects selected": "未选择可用的网格对象",
    "No applicable mesh objects found": "未找到可用的网格对象",
    "Please select a mesh object": "请选择网格对象",
    "Removed from {} objects": "已从{}个对象移除",
    " ({} materials restored)": "（恢复了{}个材质）",
    "No target found to remove": "未找到要移除的对象",
    "Created vertex group '{}' in {} objects": "在{}个对象中创建顶点组'{}'",
    "Applied settings: {}": "已应用设置: {}",
    "All settings are already optimized": "所有设置已是最优",
    "Failed to switch mode. Please switch manually.": "切换模式失败，请手动切换。",
    "Drawing mode started (Esc to end)": "开始绘制模式（Esc结束）",
    "Settings saved: {}": "设置已保存: {}",
    "Settings loaded: {}": "设置已读取: {}",
    "Preset '{}' saved": "预设'{}'已保存",
    "Preset '{}' removed": "预设'{}'已删除",
    "Preset '{}' applied": "预设'{}'已应用",
    "No preset found to apply": "未找到可应用的预设",
    "Failed to save settings": "保存设置失败",
    "Failed to load settings": "读取设置失败",
    "Thickness of the outline": "轮廓线粗细",
    "Color of the outline": "轮廓线颜色",
    "Boundary position between shadow and highlight": "阴影与高光的边界位置",
    "Shadow color (midtone shadow)": "阴影色（中间阴影）",
    "Deeper shadow color": "更深的阴影色",
    "Color of the highlighted parts": "高光部分颜色",
    "Number of shadow steps (2 or 3)": "阴影段数（2或3）",
    "Smoothness of shadow boundaries": "阴影边界平滑度",
    "Distinct boundary like toon shaders": "像卡通着色器的清晰边界",
    "Smooth gradient with linear interpolation": "线性插值的平滑渐变",
    "Natural gradient with easing interpolation": "缓和插值的自然渐变",
    "Shadow boundary sharpness": "阴影边界硬度",
    "Shadow opacity (0 to 1)": "阴影不透明度（0-1）",
    "Show sharp highlights": "显示锐利高光",
    "Size of the highlight": "高光大小",
    "Color of the highlight (usually white)": "高光颜色（通常白色）",
    "Add rim light or shadow around edges": "在边缘添加轮廓光/阴影",
    "Color of the rim light": "轮廓光颜色",
    "Brightness of the rim light": "轮廓光亮度",
    "Spread of the rim light": "轮廓光范围",
    "Light direction for vector control": "向量控制的光方向",
    "Sync with sunlight rotation using drivers": "使用驱动与太阳光旋转同步",
    "Light boost for Cycles": "Cycles的光照补正",
    "Create a grease pencil object for drawing on mesh surface": "创建可在网格表面绘制的Grease Pencil对象",
    "Toggle real-time edge line display in viewport": "切换视口实时边线显示",
    "Toggle high-quality line rendering (Freestyle)": "切换高质量线条渲染（Freestyle）",
    "Export current settings as a JSON file": "将当前设置导出为JSON文件",
    "Import settings from a JSON file": "从JSON文件导入设置",
    "Read toon settings from the active object into the UI": "从活动对象读取设置到UI",
    "Apply settings to make render result match viewport": "让渲染结果与视口匹配",
    "Current Render Engine: {}": "当前渲染引擎: {}",
    "⚠ Cycles support is in development": "⚠ Cycles支持正在开发中",
    "Use 'Vector Control' shading mode for Cycles": "Cycles请使用“向量控制”模式",
    "* Auto: adjusts display order automatically": "※自动: 自动调整显示顺序",
    "* Manual: use Material Offset to fix overlaps": "※手动: 用材质偏移修正重叠",
    "* On: Line Art preview in viewport": "※开: 视口Line Art预览",
    "* On: Freestyle lines in final render": "※开: 最终渲染输出Freestyle线",
    "* Light Boost: overall light intensity": "※光强补正: 整体亮度",
    "* Shadow Strength: darkness of shadows": "※阴影强度: 阴影深度",
}
ko_data = {
    "Auto Update": "자동 업데이트",
    "* Synchronize all objects automatically": "※모든 오브젝트를 자동으로 동기화 업데이트",
    "* Real-time update for selected objects only": "※선택한 오브젝트만 실시간 업데이트",
    "* Synchronize all toon settings": "※모든 툰 설정 동기화",
    "Apply / Update:": "적용/업데이트:",
    "Apply to Selected": "선택 항목에 적용",
    "Apply to All": "전체에 적용",
    "Remove from Selected": "선택 항목에서 제거",
    "Update": "업데이트",
    "Apply Toon Shader to selected mesh objects": "선택한 메시에 툰 셰이더 적용",
    "Apply Toon Shader to all mesh objects in the scene": "씬의 모든 메시에 툰 셰이더 적용",
    "Remove Toon Shader from selected objects": "선택한 오브젝트에서 툰 셰이더 제거",
    "Create a vertex group to control outline thickness": "외곽선 두께 제어용 버텍스 그룹 생성",
    "OMOSEN+ [Basic Settings]": "OMOSEN+ [기본 설정]",
    "Mode": "모드",
    "* All objects will share the same material": "※모든 오브젝트가 동일한 재질을 공유",
    "* Create new material while preserving textures": "※텍스처를 유지한 채 새 재질 생성",
    "* Insert nodes into existing materials": "※기존 재질에 노드 삽입",
    "Shared Material": "공유 재질",
    "Preserve Textures": "텍스처 유지",
    "Insert Nodes (Non-destructive)": "노드 삽입(비파괴)",
    "Insert Nodes": "노드 삽입",
    "OMOSEN+ [Presets]": "OMOSEN+ [프리셋]",
    "Custom": "커스텀",
    "Anime Style": "애니 스타일",
    "Game Style": "게임 스타일",
    "Manga Style": "만화 스타일",
    "Preset": "프리셋",
    "Style preset": "스타일 프리셋",
    "Custom settings": "커스텀 설정",
    "Sharp shadows": "선명한 그림자",
    "Soft shadows": "부드러운 그림자",
    "Thick outlines, 3 shadow steps": "굵은 외곽선, 그림자 3단계",
    "OMOSEN+ [Outline Settings]": "OMOSEN+ [외곽선 설정]",
    "Thickness": "두께",
    "Color": "색상",
    "Outline Offset": "외곽선 표시 위치",
    "Auto Set": "자동 설정",
    "Material Offset": "재질 오프셋",
    "* Adjust when multiple materials exist": "※복수 재질이 있을 때 조정",
    "Control Thickness by Part": "부위별 두께 제어",
    "Create Control Vertex Group": "제어용 버텍스 그룹 생성",
    "* After creation, adjust thickness via Weight Paint": "※생성 후 웨이트 페인트로 두께 조정",
    "Vertex Group": "버텍스 그룹",
    "Line Thickness Adjustment": "선 두께 조정",
    "OMOSEN+ [Inner Line Settings]": "OMOSEN+ [내선 설정]",
    "Free Drawing": "자유 그리기",
    "Line Drawing": "선 그리기",
    "Create Drawing Pen": "그리기 펜 생성",
    "* Draw directly on the mesh surface": "※메시 표면에 직접 그릴 수 있음",
    "Line Art (Viewport)": "Line Art(뷰포트)",
    "Real-time Preview": "실시간 미리보기",
    "Freestyle (Render)": "Freestyle(렌더)",
    "High Quality Rendering": "고품질 렌더링",
    "Line Thickness": "선 두께",
    "Line Color": "선 색상",
    "Show edge lines in viewport (real-time)": "뷰포트에서 엣지 라인 표시(실시간)",
    "High-quality lines during rendering (Freestyle)": "렌더링 시 고품질 라인(Freestyle)",
    "Enable Line Art": "Line Art 사용",
    "Enable Freestyle": "Freestyle 사용",
    "OMOSEN+ [Shading Settings]": "OMOSEN+ [쉐이딩 설정]",
    "Shadow steps": "그림자 단계",
    "Interpolation": "보간",
    "Constant (Stepped)": "단계(스텝)",
    "Linear": "선형",
    "Ease (Very Smooth)": "이징(매우 부드럽게)",
    "Method": "방식",
    "Lighting (Eevee)": "조명 반영(Eevee)",
    "Vector Control (Cycles/Eevee)": "벡터 제어(Cycles/Eevee)",
    "Light Direction": "빛 방향",
    "Sunlight Sync": "태양광 동기화",
    "Shadow Step": "그림자 범위",
    "Shadow Range": "그림자 범위",
    "Shadow Hardness": "그림자 경도",
    "Shadow Strength": "그림자 강도",
    "Use Specular": "스페큘러 사용",
    "Specular Size": "스페큘러 크기",
    "Specular Color": "스페큘러 색",
    "Use Rim Light": "림 라이트 사용",
    "Rim Light Color": "림 라이트 색",
    "Rim Light Strength": "림 라이트 강도",
    "Rim Light Width": "림 라이트 폭",
    "Shadow Color 1": "그림자 색1",
    "Shadow Color 2": "그림자 색2",
    "Light Boost": "광량 보정",
    "Light Mix (Cycles)": "라이트 믹스(Cycles)",
    "Blend real lights with toon result": "실제 라이트와 툰 결과 혼합",
    "Shadow calculation method (for Cycles compatibility)": "그림자 계산 방식(Cycles 호환)",
    "Directly reflect scene lights": "씬 라이트를 직접 반영",
    "Calculate as light from a specific direction": "지정 방향의 빛으로 계산",
    "Material Mode": "재질 모드",
    "Material application method": "재질 적용 방식",
    "OMOSEN+ [Render Settings]": "OMOSEN+ [렌더 설정]",
    "One-click Setup:": "원클릭 설정:",
    "Set Render to Match Viewport": "뷰포트와 렌더를 일치 설정",
    "Description:": "설명:",
    "Automatically adjusts these settings:": "다음 설정을 자동 조정:",
    "- Color Management: Standard": "・컬러 관리: Standard",
    "- Eevee: Soft Shadows OFF": "・Eevee: 소프트 섀도우 끔",
    "- Eevee: Ambient Occlusion OFF": "・Eevee: 앰비언트 오클루전 끔",
    "- Eevee: Bloom OFF": "・Eevee: 블룸 끔",
    "- Eevee: Shadow Resolution UP": "・Eevee: 그림자 해상도 증가",
    "Tip: For perfect flat shading": "팁: 완전한 평면 쉐이딩",
    "- Set Light Size/Angle to 0": "・라이트 크기/각도를 0으로",
    "- Increase Shadow Hardness to 100+": "・그림자 경도를 100 이상",
    "- Set Color Management to Standard": "・컬러 관리를 Standard로",
    "  (Render Properties > Color Management)": "  (렌더 속성 > 컬러 관리)",
    "OMOSEN+ [System Settings]": "OMOSEN+ [시스템]",
    "Custom Presets (Asset)": "커스텀 프리셋(Asset)",
    "Apply Selected Preset": "선택한 프리셋 적용",
    "Export / Import Settings": "설정 내보내기/가져오기",
    "Save": "저장",
    "Load": "불러오기",
    "Save Current Settings": "현재 설정 저장",
    "Remove Preset": "프리셋 삭제",
    "Apply Preset": "프리셋 적용",
    "Automatically update materials on change": "변경 시 재질 자동 업데이트",
    "Export Settings": "설정 내보내기",
    "Import Settings": "설정 가져오기",
    "Preset Name": "프리셋 이름",
    "Active Preset": "활성 프리셋",
    "Save all current parameters as a new preset": "현재 모든 파라미터를 새 프리셋으로 저장",
    "Remove the selected preset": "선택한 프리셋 삭제",
    "Apply the selected preset to the scene": "선택한 프리셋을 씬에 적용",
    "Export current settings as a JSON file": "현재 설정을 JSON으로 내보내기",
    "Import settings from a JSON file": "JSON에서 설정 가져오기",
    "System Management": "시스템 관리",
    "Reset All Settings": "전체 설정 초기화",
    "Clear All Presets": "모든 프리셋 삭제",
    "Load from Active": "선택 항목에서 설정 불러오기",
    "Settings loaded from object": "오브젝트에서 설정을 불러왔습니다",
    "Applied to {} objects": "{}개의 오브젝트에 적용",
    " ({} materials converted)": "({}개의 재질 변환)",
    "No applicable mesh objects selected": "적용 가능한 메쉬가 선택되지 않았습니다",
    "No applicable mesh objects found": "적용 가능한 메쉬가 없습니다",
    "Please select a mesh object": "메쉬 오브젝트를 선택해주세요",
    "Removed from {} objects": "{}개의 오브젝트에서 제거",
    " ({} materials restored)": "({}개의 재질 복원)",
    "No target found to remove": "제거할 대상이 없습니다",
    "Created vertex group '{}' in {} objects": "{}개의 오브젝트에 버텍스 그룹 '{}' 생성",
    "Applied settings: {}": "설정 적용: {}",
    "All settings are already optimized": "모든 설정이 이미 최적화됨",
    "Failed to switch mode. Please switch manually.": "모드 전환 실패. 수동으로 전환해주세요.",
    "Drawing mode started (Esc to end)": "그리기 모드 시작(ESC로 종료)",
    "Settings saved: {}": "설정 저장: {}",
    "Settings loaded: {}": "설정 불러옴: {}",
    "Preset '{}' saved": "프리셋 '{}' 저장",
    "Preset '{}' removed": "프리셋 '{}' 삭제",
    "Preset '{}' applied": "프리셋 '{}' 적용",
    "No preset found to apply": "적용할 프리셋이 없습니다",
    "Failed to save settings": "설정 저장 실패",
    "Failed to load settings": "설정 불러오기 실패",
    "Thickness of the outline": "외곽선 두께",
    "Color of the outline": "외곽선 색",
    "Boundary position between shadow and highlight": "그림자와 하이라이트의 경계 위치",
    "Shadow color (midtone shadow)": "그림자 색(중간 그림자)",
    "Deeper shadow color": "더 깊은 그림자 색",
    "Color of the highlighted parts": "하이라이트 색",
    "Number of shadow steps (2 or 3)": "그림자 단계 수(2 또는 3)",
    "Smoothness of shadow boundaries": "그림자 경계의 부드러움",
    "Distinct boundary like toon shaders": "툰 셰이더 같은 선명한 경계",
    "Smooth gradient with linear interpolation": "선형 보간의 부드러운 그라데이션",
    "Natural gradient with easing interpolation": "이징 보간의 자연스러운 그라데이션",
    "Shadow boundary sharpness": "그림자 경계 경도",
    "Shadow opacity (0 to 1)": "그림자 불투명도(0~1)",
    "Show sharp highlights": "선명한 하이라이트 표시",
    "Size of the highlight": "하이라이트 크기",
    "Color of the highlight (usually white)": "하이라이트 색(보통 흰색)",
    "Add rim light or shadow around edges": "가장자리에 림 라이트/그림자 추가",
    "Color of the rim light": "림 라이트 색",
    "Brightness of the rim light": "림 라이트 밝기",
    "Spread of the rim light": "림 라이트 범위",
    "Light direction for vector control": "벡터 제어용 광 방향",
    "Sync with sunlight rotation using drivers": "드라이버로 태양광 회전과 동기화",
    "Light boost for Cycles": "Cycles용 광량 보정",
    "Create a grease pencil object for drawing on mesh surface": "메시 표면에 그릴 수 있는 그리스 펜슬 오브젝트 생성",
    "Toggle real-time edge line display in viewport": "뷰포트 실시간 엣지 라인 표시 전환",
    "Toggle high-quality line rendering (Freestyle)": "고품질 라인 렌더링(Freestyle) 전환",
    "Export current settings as a JSON file": "현재 설정을 JSON 파일로 내보내기",
    "Import settings from a JSON file": "JSON 파일에서 설정 가져오기",
    "Read toon settings from the active object into the UI": "활성 오브젝트의 설정을 UI로 읽기",
    "Apply settings to make render result match viewport": "렌더 결과를 뷰포트와 일치",
    "Current Render Engine: {}": "현재 렌더 엔진: {}",
    "⚠ Cycles support is in development": "⚠ Cycles 지원은 개발 중",
    "Use 'Vector Control' shading mode for Cycles": "Cycles에서는 '벡터 제어' 모드를 사용하세요",
    "* Auto: adjusts display order automatically": "※자동: 표시 순서를 자동 조정",
    "* Manual: use Material Offset to fix overlaps": "※수동: 재질 오프셋으로 겹침 수정",
    "* On: Line Art preview in viewport": "※ON: 뷰포트에서 Line Art 미리보기",
    "* On: Freestyle lines in final render": "※ON: 최종 렌더에서 Freestyle 라인",
    "* Light Boost: overall light intensity": "※광량 보정: 전체 밝기",
    "* Shadow Strength: darkness of shadows": "※그림자 강도: 그림자 농도",
}
def get_translations():
    """辞書を複数のロケールとコンテキストで展開して返す"""
    translations = {}
    items_ja = {}
    items_zh = {}
    items_ko = {}
    for msgid, msgstr in raw_data.items():
        for ctx in [None, "*", "UI", "Property", "Operator"]:
            items_ja[(ctx, msgid)] = msgstr
            items_zh[(ctx, msgid)] = zh_data.get(msgid, msgid)
            items_ko[(ctx, msgid)] = ko_data.get(msgid, msgid)
    translations["ja_JP"] = items_ja
    translations["ja_JP.UTF-8"] = items_ja
    translations["zh_CN"] = items_zh
    translations["zh_CN.UTF-8"] = items_zh
    translations["ko_KR"] = items_ko
    translations["ko_KR.UTF-8"] = items_ko
    return translations
translations_dict = get_translations()