"""ハンドラー関数（タイマー方式に変更）"""
import bpy
import mathutils
@bpy.app.handlers.persistent
def sun_light_sync_handler(scene):
    """サンライトの回転をリアルタイムに同期するハンドラー"""
    if not hasattr(scene, "omosen_props"):
        return
    props = scene.omosen_props
    if not props.use_sun_driver:
        return
    for obj in scene.objects:
        if obj.type == 'LIGHT' and obj.data.type == 'SUN':
            direction = obj.matrix_world.to_quaternion() @ mathutils.Vector((0.0, 0.0, 1.0))
            if (mathutils.Vector(props.light_direction) - direction).length > 0.001:
                props.light_direction = direction
            break
_last_selection_state = (None, -1)
def selection_timer():
    """定期的にアクティブオブジェクトやスロットの変更をチェック"""
    global _last_selection_state
    interval = 0.1
    try:
        if bpy.app.background:
            return interval
        scene = bpy.context.scene
        if not scene:
            return interval
        active_obj = bpy.context.active_object
        current_name = active_obj.name if active_obj else None
        current_mat_idx = active_obj.active_material_index if active_obj else -1
        current_state = (current_name, current_mat_idx)
        if current_state != _last_selection_state:
            _last_selection_state = current_state
            if active_obj and active_obj.type == 'MESH':
                print(f"\n[OMOSEN+] Selection Changed: {current_name} (Slot {current_mat_idx+1})")
                from .core.sync import sync_props_from_active_object
                sync_props_from_active_object(scene)
    except Exception as e:
        import traceback
        print(f"\n[OMOSEN+] Timer Error: {e}")
        print(traceback.format_exc())
    return interval
@bpy.app.handlers.persistent
def ensure_timer_registered(dummy):
    """ファイル読み込み後にタイマーが登録されているか確認"""
    if not bpy.app.timers.is_registered(selection_timer):
        bpy.app.timers.register(selection_timer)
        print("[OMOSEN+] Timer re-registered after file load")