"""設定リセット操作"""
import bpy
from bpy.types import Operator
class OMOSEN_OT_ResetSettings(Operator):
    """全ての設定とパネル状態を初期化"""
    bl_idname = "omosen.reset_settings"
    bl_label = "設定を初期化"
    bl_description = "全ての設定とパネルのレイアウト状態を初期化します"
    bl_options = {'REGISTER', 'UNDO'}
    def execute(self, context):
        """リセット実行"""
        props = context.scene.omosen_props
        props.is_syncing = True
        try:
            props.outline_width = 0.002
            props.outline_color = (0.0, 0.0, 0.0)
            props.outline_vertex_group = ""
            props.shadow_step = 0.55
            props.shadow_color = (0.6, 0.6, 0.7)
            props.shadow_color_2 = (0.4, 0.4, 0.5)
            props.highlight_color = (1.1, 1.1, 1.1)
            props.shadow_levels = 2
            props.interpolation = 'CONSTANT'
            props.shadow_hardness = 10.0
            props.shadow_strength = 1.0
            props.use_specular = False
            props.specular_size = 0.05
            props.specular_color = (0.033105, 0.033105, 0.033105)
            props.use_rim_light = False
            props.rim_light_color = (1.0, 1.0, 1.0)
            props.rim_light_strength = 0.05
            props.rim_light_width = 0.8
            props.shading_method = 'LIGHTING'
            props.light_direction = (0.5, 0.5, 1.0)
            props.use_sun_driver = False
            props.light_boost = 1.0
            props.use_line_art = False
            props.use_freestyle = False
            props.edge_line_thickness = 1.5
            props.edge_line_color = (0.0, 0.0, 0.0)
            props.material_mode = 'INSERT'
            props.preset = 'CUSTOM'
            props.auto_material_offset = True
            props.material_offset = 1
            props.active_preset_index = 0
            self._reset_panel_states(context)
        finally:
            props.is_syncing = False
        from ..core import materials
        materials.update_materials(context)
        return {'FINISHED'}
    def _reset_panel_states(self, context):
        """パネルの折りたたみ状態をリセット"""
        try:
            for screen in bpy.data.screens:
                for area in screen.areas:
                    if area.type == 'VIEW_3D':
                        for region in area.regions:
                            if region.type == 'UI':
                                region.tag_redraw()
            if hasattr(context, 'workspace'):
                context.workspace.update_tag()
        except Exception:
            pass
class OMOSEN_OT_ClearPresets(Operator):
    """保存されたプリセットを全て削除"""
    bl_idname = "omosen.clear_presets"
    bl_label = "プリセットを全削除"
    bl_description = "保存された全てのプリセットを削除します"
    bl_options = {'REGISTER', 'UNDO'}
    def execute(self, context):
        """プリセット削除実行"""
        props = context.scene.omosen_props
        count = len(props.custom_presets)
        if count == 0:
            return {'CANCELLED'}
        props.custom_presets.clear()
        props.active_preset_index = 0
        from ..core.io import clear_custom_presets
        clear_custom_presets(context)
        return {'FINISHED'}
    def invoke(self, context, event):
        """確認のみ"""
        props = context.scene.omosen_props
        if len(props.custom_presets) == 0:
            return {'CANCELLED'}
        return context.window_manager.invoke_confirm(self, event)
classes = (
    OMOSEN_OT_ResetSettings,
    OMOSEN_OT_ClearPresets,
)
def register():
    for cls in classes:
        bpy.utils.register_class(cls)
def unregister():
    for cls in reversed(classes):
        bpy.utils.unregister_class(cls)