"""プロパティ定義（循環インポート回避のためラッパー方式を採用）"""
import bpy
from bpy.props import FloatProperty, FloatVectorProperty, IntProperty, EnumProperty, BoolProperty, StringProperty
def _update_materials_wrapper(self, context):
    """遅延インポートで循環参照を回避"""
    if getattr(self, "is_syncing", False):
        return
    from .core import materials
    materials.update_materials(context)
def _apply_preset_wrapper(self, context):
    """遅延インポートで循環参照を回避"""
    if getattr(self, "is_syncing", False):
        return
    from .core import presets
    presets.apply_preset(self, context)
class OMOSEN_CustomPreset(bpy.types.PropertyGroup):
    """カスタムプリセットの1項目を保持"""
    name: StringProperty(name="Preset Name", default="New Preset")
class OMOSEN_Properties(bpy.types.PropertyGroup):
    """トゥーンシェーダーの設定を保持するプロパティ"""
    custom_presets: bpy.props.CollectionProperty(type=OMOSEN_CustomPreset)
    active_preset_index: IntProperty(name="Active Preset", default=0)
    is_syncing: BoolProperty(default=False, options={'SKIP_SAVE', 'HIDDEN'})
    outline_width: FloatProperty(
        name="Thickness",
        description="Thickness of the outline",
        default=0.002,
        min=0.001,
        max=0.2,
        step=0.1,
        precision=3,
        update=_update_materials_wrapper
    )
    outline_color: FloatVectorProperty(
        name="Color",
        description="Color of the outline",
        subtype='COLOR',
        default=(0.0, 0.0, 0.0),
        min=0.0,
        max=1.0,
        update=_update_materials_wrapper
    )
    shadow_step: FloatProperty(
        name="Shadow Step",
        description="Boundary position between shadow and highlight",
        default=0.55,
        min=0.0,
        max=1.0,
        step=1,
        precision=2,
        update=_update_materials_wrapper
    )
    shadow_color: FloatVectorProperty(
        name="Shadow Color 1",
        description="Shadow color (midtone shadow)",
        subtype='COLOR',
        default=(0.6, 0.6, 0.7),
        min=0.0,
        max=1.0,
        update=_update_materials_wrapper
    )
    shadow_color_2: FloatVectorProperty(
        name="Shadow Color 2",
        description="Deeper shadow color",
        subtype='COLOR',
        default=(0.4, 0.4, 0.5),
        min=0.0,
        max=1.0,
        update=_update_materials_wrapper
    )
    highlight_color: FloatVectorProperty(
        name="Highlight Color",
        description="Color of the highlighted parts",
        subtype='COLOR',
        default=(1.1, 1.1, 1.1),
        min=0.0,
        max=2.0,
        update=_update_materials_wrapper
    )
    shadow_levels: IntProperty(
        name="Shadow steps",
        description="Number of shadow steps (2 or 3)",
        default=2,
        min=2,
        max=3,
        update=_update_materials_wrapper
    )
    interpolation: EnumProperty(
        name="Interpolation",
        description="Smoothness of shadow boundaries",
        items=[
            ('CONSTANT', "Constant (Stepped)", "Distinct boundary like toon shaders"),
            ('LINEAR', "Linear", "Smooth gradient with linear interpolation"),
            ('EASE', "Ease (Very Smooth)", "Natural gradient with easing interpolation"),
        ],
        default='CONSTANT',
        update=_update_materials_wrapper
    )
    light_boost: FloatProperty(
        name="Light Boost",
        description="Light boost for Cycles",
        default=1.0,
        min=0.1,
        max=5.0,
        step=0.1,
        precision=1,
        update=_update_materials_wrapper
    )
    cycles_light_mix: FloatProperty(
        name="Light Mix (Cycles)",
        description="Blend real lights with toon result",
        default=0.2,
        min=0.0,
        max=1.0,
        step=0.05,
        precision=2,
        update=_update_materials_wrapper
    )
    shadow_hardness: FloatProperty(
        name="Shadow Hardness",
        description="Shadow boundary sharpness",
        default=10.0,
        min=1.0,
        max=1000.0,
        step=1.0,
        precision=1,
        update=_update_materials_wrapper
    )
    shadow_strength: FloatProperty(
        name="Shadow Strength",
        description="Shadow opacity (0 to 1)",
        default=1.0,
        min=0.0,
        max=1.0,
        step=0.1,
        precision=2,
        update=_update_materials_wrapper
    )
    use_specular: BoolProperty(
        name="Use Specular",
        description="Show sharp highlights",
        default=False,
        update=_update_materials_wrapper
    )
    specular_size: FloatProperty(
        name="Specular Size",
        description="Size of the highlight",
        default=0.05,
        min=0.0,
        max=1.0,
        step=0.05,
        precision=2,
        update=_update_materials_wrapper
    )
    specular_color: FloatVectorProperty(
        name="Specular Color",
        description="Color of the highlight (usually white)",
        subtype='COLOR',
        default=(0.033105, 0.033105, 0.033105),
        min=0.0,
        max=2.0,
        update=_update_materials_wrapper
    )
    use_rim_light: BoolProperty(
        name="Use Rim Light",
        description="Add rim light or shadow around edges",
        default=False,
        update=_update_materials_wrapper
    )
    rim_light_color: FloatVectorProperty(
        name="Rim Light Color",
        description="Color of the rim light",
        subtype='COLOR',
        default=(1.0, 1.0, 1.0),
        min=0.0,
        max=2.0,
        update=_update_materials_wrapper
    )
    rim_light_strength: FloatProperty(
        name="Rim Light Strength",
        description="Brightness of the rim light",
        default=0.05,
        min=0.0,
        max=5.0,
        step=0.1,
        precision=2,
        update=_update_materials_wrapper
    )
    rim_light_width: FloatProperty(
        name="Rim Light Width",
        description="Spread of the rim light",
        default=0.8,
        min=0.0,
        max=1.0,
        step=0.05,
        precision=2,
        update=_update_materials_wrapper
    )
    shading_method: EnumProperty(
        name="Method",
        description="Shadow calculation method (for Cycles compatibility)",
        items=[
            ('LIGHTING', "Lighting (Eevee)", "Directly reflect scene lights"),
            ('VECTOR', "Vector Control (Cycles/Eevee)", "Calculate as light from a specific direction"),
        ],
        default='LIGHTING',
        update=_update_materials_wrapper
    )
    light_direction: FloatVectorProperty(
        name="Light Direction",
        description="Light direction for vector control",
        subtype='DIRECTION',
        default=(0.5, 0.5, 1.0),
        update=_update_materials_wrapper
    )
    use_sun_driver: BoolProperty(
        name="Sunlight Sync",
        description="Sync with sunlight rotation using drivers",
        default=False,
        update=_update_materials_wrapper
    )
    preset: EnumProperty(
        name="Preset",
        description="Style preset",
        items=[
            ('CUSTOM', "Custom", "Custom settings"),
            ('ANIME', "Anime Style", "Sharp shadows"),
            ('GAME', "Game Style", "Soft shadows"),
            ('MANGA', "Manga Style", "Thick outlines, 3 shadow steps"),
        ],
        default='CUSTOM',
        update=_apply_preset_wrapper
    )
    material_mode: EnumProperty(
        name="Material Mode",
        description="Material application method",
        items=[
            ('SHARED', "Shared Material", "All objects will share the same material"),
            ('PRESERVE', "Preserve Textures", "Create new material while preserving textures"),
            ('INSERT', "Insert Nodes (Non-destructive)", "Insert nodes into existing materials"),
        ],
        default='INSERT'
    )
    use_line_art: BoolProperty(
        name="Enable Line Art",
        description="Show edge lines in viewport (real-time)",
        default=False
    )
    use_freestyle: BoolProperty(
        name="Enable Freestyle",
        description="High-quality lines during rendering (Freestyle)",
        default=False
    )
    edge_line_thickness: FloatProperty(
        name="Line Thickness",
        description="Line Thickness",
        default=1.5,
        min=0.1,
        max=10.0
    )
    edge_line_color: FloatVectorProperty(
        name="Line Color",
        description="Line Color",
        subtype='COLOR',
        default=(0.0, 0.0, 0.0),
        min=0.0,
        max=1.0
    )
    auto_material_offset: BoolProperty(
        name="Auto Set",
        description="Automatically set material offset",
        default=True
    )
    material_offset: IntProperty(
        name="Material Offset",
        description="Material slot index for manual setting",
        default=1,
        min=0,
        max=10
    )
    outline_vertex_group: StringProperty(
        name="Vertex Group",
        description="Vertex group name for partial outline",
        default=""
    )