"""UIパネル - システム設定（保存・読み込みなど）"""
import bpy
from bpy.types import Panel, UIList
class OMOSEN_UL_PresetList(UIList):
    """カスタムプリセットのリスト表示"""
    def draw_item(self, context, layout, data, item, icon, active_data, active_propname, index):
        if self.layout_type in {'DEFAULT', 'COMPACT'}:
            layout.label(text=item.name, icon='PRESET')
        elif self.layout_type in {'GRID'}:
            layout.alignment = 'CENTER'
            layout.label(text="", icon='PRESET')
class OMOSEN_PT_SettingsPanel(Panel):
    """システム設定パネル"""
    bl_label = "OMOSEN+ [System Settings]"
    bl_idname = "OMOSEN_PT_settings_panel"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = 'OMOSEN+'
    bl_options = {'DEFAULT_CLOSED'}
    def draw(self, context):
        layout = self.layout
        props = context.scene.omosen_props
        tr = bpy.app.translations.pgettext_iface
        if len(props.custom_presets) == 0:
            from ..core.io import load_custom_presets
            load_custom_presets(context)
        box = layout.box()
        box.label(text=tr("Custom Presets (Asset)"), icon='ASSET_MANAGER')
        row = box.row()
        row.template_list("OMOSEN_UL_PresetList", "", props, "custom_presets", props, "active_preset_index")
        col = row.column(align=True)
        col.operator("omosen.add_custom_preset", icon='ADD', text="")
        col.operator("omosen.remove_custom_preset", icon='REMOVE', text="")
        box.operator("omosen.apply_custom_preset", text=tr("Apply Selected Preset"), icon='CHECKMARK')
        layout.separator()
        box = layout.box()
        box.label(text=tr("Export / Import Settings"), icon='DISK_DRIVE')
        row = box.row(align=True)
        row.operator("omosen.export_settings", text=tr("Save"), icon='EXPORT')
        row.operator("omosen.import_settings", text=tr("Load"), icon='IMPORT')
        layout.separator()
        box = layout.box()
        box.label(text=tr("System Management"), icon='PREFERENCES')
        col = box.column(align=True)
        row = col.row()
        row.alert = True
        row.scale_y = 1.3
        row.operator("omosen.reset_settings", text=tr("Reset All Settings"), icon='FILE_REFRESH')
        col.separator(factor=0.5)
        row = col.row()
        row.alert = True
        row.operator("omosen.clear_presets", text=tr("Clear All Presets"), icon='TRASH')