"""コア - 設定の入出力"""
import json
import bpy
def get_settings_dict(context):
    """現在のシーン設定を辞書形式で取得"""
    props = context.scene.omosen_props
    data = {
        "version": "1.1.3",
        "outline_width": props.outline_width,
        "outline_color": list(props.outline_color),
        "shadow_step": props.shadow_step,
        "shadow_color": list(props.shadow_color),
        "shadow_color_2": list(props.shadow_color_2),
        "highlight_color": list(props.highlight_color),
        "shadow_levels": props.shadow_levels,
        "interpolation": props.interpolation,
        "light_boost": props.light_boost,
        "cycles_light_mix": props.cycles_light_mix,
        "shadow_hardness": props.shadow_hardness,
        "shadow_strength": props.shadow_strength,
        "use_specular": props.use_specular,
        "specular_size": props.specular_size,
        "specular_color": list(props.specular_color),
        "use_rim_light": props.use_rim_light,
        "rim_light_color": list(props.rim_light_color),
        "rim_light_strength": props.rim_light_strength,
        "rim_light_width": props.rim_light_width,
        "shading_method": props.shading_method,
        "light_direction": list(props.light_direction),
        "use_sun_driver": props.use_sun_driver,
        "edge_line_thickness": props.edge_line_thickness,
        "edge_line_color": list(props.edge_line_color),
        "auto_material_offset": props.auto_material_offset,
        "material_offset": props.material_offset,
        "outline_vertex_group": props.outline_vertex_group
    }
    return data
def apply_settings_dict(context, data):
    """辞書データをシーン設定に適用"""
    props = context.scene.omosen_props
    try:
        if "outline_width" in data: props.outline_width = data["outline_width"]
        if "outline_color" in data: props.outline_color = data["outline_color"]
        if "shadow_step" in data: props.shadow_step = data["shadow_step"]
        if "shadow_color" in data: props.shadow_color = data["shadow_color"]
        if "shadow_color_2" in data: props.shadow_color_2 = data["shadow_color_2"]
        if "highlight_color" in data: props.highlight_color = data["highlight_color"]
        if "shadow_levels" in data: props.shadow_levels = data["shadow_levels"]
        if "interpolation" in data: props.interpolation = data["interpolation"]
        if "light_boost" in data: props.light_boost = data["light_boost"]
        if "cycles_light_mix" in data: props.cycles_light_mix = data["cycles_light_mix"]
        if "shadow_hardness" in data: props.shadow_hardness = data["shadow_hardness"]
        if "shadow_strength" in data: props.shadow_strength = data["shadow_strength"]
        if "use_specular" in data: props.use_specular = data["use_specular"]
        if "specular_size" in data: props.specular_size = data["specular_size"]
        if "specular_color" in data: props.specular_color = data["specular_color"]
        if "use_rim_light" in data: props.use_rim_light = data["use_rim_light"]
        if "rim_light_color" in data: props.rim_light_color = data["rim_light_color"]
        if "rim_light_strength" in data: props.rim_light_strength = data["rim_light_strength"]
        if "rim_light_width" in data: props.rim_light_width = data["rim_light_width"]
        if "shading_method" in data: props.shading_method = data["shading_method"]
        if "light_direction" in data: props.light_direction = data["light_direction"]
        if "use_sun_driver" in data: props.use_sun_driver = data["use_sun_driver"]
        if "edge_line_thickness" in data: props.edge_line_thickness = data["edge_line_thickness"]
        if "edge_line_color" in data: props.edge_line_color = data["edge_line_color"]
        if "auto_material_offset" in data: props.auto_material_offset = data["auto_material_offset"]
        if "material_offset" in data: props.material_offset = data["material_offset"]
        if "outline_vertex_group" in data: props.outline_vertex_group = data["outline_vertex_group"]
    except Exception as e:
        print(f"OMOSEN+ Apply Settings Error: {e}")
import os
def get_presets_filepath():
    """プリセット保存ファイルのパスを取得"""
    addon_dir = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))
    return os.path.join(addon_dir, "user_presets.json")
def save_custom_presets_dict(all_presets):
    """プリセット辞書をファイルに保存"""
    filepath = get_presets_filepath()
    with open(filepath, 'w', encoding='utf-8') as f:
        json.dump(all_presets, f, indent=4, ensure_ascii=False)
def clear_custom_presets(context=None):
    """保存済みプリセットを全削除（ファイルも空にする）"""
    save_custom_presets_dict({})
def add_and_save_preset(context, name):
    """現在の設定を、指定した名前でプリセットとして保存"""
    filepath = get_presets_filepath()
    all_data = {}
    if os.path.exists(filepath):
        try:
            with open(filepath, 'r', encoding='utf-8') as f:
                all_data = json.load(f)
        except:
            pass
    all_data[name] = get_settings_dict(context)
    save_custom_presets_dict(all_data)
    load_custom_presets(context)
def remove_and_save_preset(context, name):
    """指定した名前のプリセットを削除して保存"""
    filepath = get_presets_filepath()
    if not os.path.exists(filepath):
        return
    try:
        with open(filepath, 'r', encoding='utf-8') as f:
            all_data = json.load(f)
        if name in all_data:
            del all_data[name]
            save_custom_presets_dict(all_data)
        load_custom_presets(context)
    except:
        pass
def load_custom_presets(context):
    """ファイルからカスタムプリセットのリストを読み込み、プロパティを更新"""
    if not context or not hasattr(context.scene, "omosen_props"):
        return False
    props = context.scene.omosen_props
    filepath = get_presets_filepath()
    if not os.path.exists(filepath):
        return False
    try:
        with open(filepath, 'r', encoding='utf-8') as f:
            all_data = json.load(f)
        props.custom_presets.clear()
        for name in all_data.keys():
            item = props.custom_presets.add()
            item.name = name
        return True
    except Exception as e:
        print(f"OMOSEN+ Error: Failed to load presets: {e}")
        return False
def apply_custom_preset_by_name(context, name):
    """名前を指定してプリセットを適用"""
    filepath = get_presets_filepath()
    if not os.path.exists(filepath):
        return False
    try:
        with open(filepath, 'r', encoding='utf-8') as f:
            all_data = json.load(f)
        if name in all_data:
            apply_settings_dict(context, all_data[name])
            return True
    except:
        pass
    return False
def import_preset_from_file(context, filepath):
    """外部ファイルを読み込み、アセットリストに追加して適用する"""
    try:
        with open(filepath, 'r', encoding='utf-8') as f:
            data = json.load(f)
        name = os.path.splitext(os.path.basename(filepath))[0]
        filepath_presets = get_presets_filepath()
        all_data = {}
        if os.path.exists(filepath_presets):
            try:
                with open(filepath_presets, 'r', encoding='utf-8') as f:
                    all_data = json.load(f)
            except:
                pass
        all_data[name] = data
        save_custom_presets_dict(all_data)
        load_custom_presets(context)
        apply_settings_dict(context, data)
        return True
    except Exception as e:
        print(f"OMOSEN+ Error: Failed to import preset: {e}")
        return False
def save_settings_to_file(context, filepath):
    """設定をファイルに保存（Export機能用）"""
    data = get_settings_dict(context)
    with open(filepath, 'w', encoding='utf-8') as f:
        json.dump(data, f, indent=4)
    return True
def load_settings_from_file(context, filepath):
    """設定をファイルから読み込み（Import機能用）"""
    return import_preset_from_file(context, filepath)