"""コア - Cycles向けマテリアル操作（ベクトル方式のみ）"""
import bpy
from .materials_common import update_ramp_nodes
def _add_light_mix(nodes, links, props, toon_socket, base_color_socket=None, base_color=None):
    principled = nodes.new("ShaderNodeBsdfPrincipled")
    principled.label = "Toon_LightMixPrincipled"
    principled.location = (1500, -50)
    if base_color_socket:
        links.new(base_color_socket, principled.inputs["Base Color"])
    else:
        if base_color is None:
            base_color = (1.0, 1.0, 1.0, 1.0)
        principled.inputs["Base Color"].default_value = base_color
    mix_shader = nodes.new("ShaderNodeMixShader")
    mix_shader.label = "Toon_LightMix"
    mix_shader.location = (1700, 200)
    mix_shader.inputs[0].default_value = props.cycles_light_mix
    links.new(toon_socket, mix_shader.inputs[1])
    links.new(principled.outputs["BSDF"], mix_shader.inputs[2])
    return mix_shader
def _add_light_mix_existing(nodes, links, props, toon_socket, principled):
    mix_shader = nodes.new("ShaderNodeMixShader")
    mix_shader.label = "Toon_LightMix"
    mix_shader.location = (1700, 200)
    mix_shader.inputs[0].default_value = props.cycles_light_mix
    links.new(toon_socket, mix_shader.inputs[1])
    links.new(principled.outputs["BSDF"], mix_shader.inputs[2])
    return mix_shader
def create_toon_material(props) -> bpy.types.Material:
    """Cycles用トゥーンマテリアルを作成"""
    name = "ToonMaterial"
    if name in bpy.data.materials:
        mat = bpy.data.materials[name]
    else:
        mat = bpy.data.materials.new(name)
    mat.use_nodes = True
    mat.blend_method = 'OPAQUE'
    if hasattr(mat, 'shadow_method'):
        mat.shadow_method = 'OPAQUE'
    nodes = mat.node_tree.nodes
    links = mat.node_tree.links
    nodes.clear()
    geom = nodes.new("ShaderNodeNewGeometry")
    geom.location = (-1200, 0)
    geom.label = "Toon_Geometry"
    light_vec = nodes.new("ShaderNodeRGB")
    light_vec.location = (-1200, -300)
    light_vec.label = "Toon_LightVector"
    light_vec.outputs[0].default_value = (*props.light_direction, 1.0)
    dot = nodes.new("ShaderNodeVectorMath")
    dot.operation = 'DOT_PRODUCT'
    dot.location = (-900, 0)
    dot.label = "Toon_DotProduct"
    dot_add = nodes.new("ShaderNodeMath")
    dot_add.operation = 'ADD'
    dot_add.inputs[1].default_value = 1.0
    dot_add.location = (-650, 0)
    dot_add.label = "Toon_DotAdd"
    dot_mul = nodes.new("ShaderNodeMath")
    dot_mul.operation = 'MULTIPLY'
    dot_mul.inputs[1].default_value = 0.5
    dot_mul.location = (-400, 0)
    dot_mul.label = "Toon_DotMul"
    math_multiply = nodes.new("ShaderNodeMath")
    math_multiply.operation = 'MULTIPLY'
    math_multiply.inputs[1].default_value = props.light_boost
    math_multiply.location = (-150, 0)
    math_multiply.label = "Toon_LightBoost"
    math_hardness = nodes.new("ShaderNodeMapRange")
    math_hardness.data_type = 'FLOAT'
    math_hardness.interpolation_type = 'LINEAR'
    math_hardness.location = (100, 0)
    math_hardness.label = "Toon_Hardness"
    h_val = 1.0 / max(props.shadow_hardness, 0.001)
    math_hardness.inputs[1].default_value = props.shadow_step - h_val
    math_hardness.inputs[2].default_value = props.shadow_step + h_val
    math_hardness.inputs[3].default_value = 0.0
    math_hardness.inputs[4].default_value = 1.0
    ramp = nodes.new("ShaderNodeValToRGB")
    ramp.location = (400, 0)
    ramp.label = "Toon_ColorRamp"
    update_ramp_nodes(ramp, props)
    spec_ramp = nodes.new("ShaderNodeValToRGB")
    spec_ramp.color_ramp.interpolation = 'CONSTANT'
    spec_ramp.location = (400, -300)
    spec_ramp.label = "Toon_SpecRamp"
    spec_ramp.color_ramp.elements[0].position = 1.0 - props.specular_size
    spec_ramp.color_ramp.elements[0].color = (0, 0, 0, 1)
    if len(spec_ramp.color_ramp.elements) < 2:
        spec_ramp.color_ramp.elements.new(1.0)
    spec_ramp.color_ramp.elements[1].position = 1.0 - props.specular_size + 0.001
    spec_ramp.color_ramp.elements[1].color = (1, 1, 1, 1)
    spec_mix = nodes.new("ShaderNodeMixRGB")
    spec_mix.blend_type = 'MIX'
    spec_mix.inputs[1].default_value = (0, 0, 0, 1)
    spec_mix.inputs[2].default_value = (*props.specular_color, 1.0)
    spec_mix.location = (700, -300)
    spec_mix.label = "Toon_SpecMix"
    fresnel = nodes.new("ShaderNodeFresnel")
    fresnel.location = (100, -600)
    fresnel.label = "Toon_Fresnel"
    rim_map = nodes.new("ShaderNodeMapRange")
    rim_map.data_type = 'FLOAT'
    rim_map.interpolation_type = 'LINEAR'
    rim_map.location = (350, -600)
    rim_map.label = "Toon_RimMap"
    fresnel.inputs[0].default_value = 1.45
    rim_map.inputs[1].default_value = 1.0 - props.rim_light_width
    rim_map.inputs[2].default_value = 1.0 - props.rim_light_width + 0.05
    rim_map.inputs[3].default_value = 0.0
    rim_map.inputs[4].default_value = 1.0
    rim_mix = nodes.new("ShaderNodeMixRGB")
    rim_mix.blend_type = 'MIX'
    rim_mix.inputs[1].default_value = (0, 0, 0, 1)
    rim_mix.inputs[2].default_value = (*props.rim_light_color, 1.0)
    rim_mix.location = (600, -600)
    rim_mix.label = "Toon_RimMix"
    mix_color = nodes.new("ShaderNodeMixRGB")
    mix_color.blend_type = 'MULTIPLY'
    mix_color.inputs[0].default_value = props.shadow_strength
    mix_color.inputs[1].default_value = (*props.highlight_color, 1.0)
    mix_color.location = (750, 200)
    mix_color.label = "Toon_Mix"
    add_rim = nodes.new("ShaderNodeMixRGB")
    add_rim.blend_type = 'ADD'
    add_rim.inputs[0].default_value = props.rim_light_strength if props.use_rim_light else 0.0
    add_rim.location = (1000, 200)
    add_rim.label = "Toon_AddRim"
    add_spec = nodes.new("ShaderNodeMixRGB")
    add_spec.blend_type = 'ADD'
    add_spec.inputs[0].default_value = 1.0 if props.use_specular else 0.0
    add_spec.location = (1250, 200)
    add_spec.label = "Toon_AddSpec"
    emission = nodes.new("ShaderNodeEmission")
    emission.inputs[1].default_value = 1.0
    emission.location = (1500, 200)
    emission.label = "Toon_Emission"
    output = nodes.new("ShaderNodeOutputMaterial")
    output.location = (1950, 200)
    links.new(geom.outputs["Normal"], dot.inputs[0])
    links.new(light_vec.outputs[0], dot.inputs[1])
    links.new(dot.outputs["Value"], dot_add.inputs[0])
    links.new(dot_add.outputs[0], dot_mul.inputs[0])
    links.new(dot_mul.outputs[0], math_multiply.inputs[0])
    links.new(math_multiply.outputs[0], math_hardness.inputs[0])
    links.new(math_hardness.outputs[0], ramp.inputs[0])
    links.new(dot_mul.outputs[0], spec_ramp.inputs[0])
    links.new(spec_ramp.outputs[0], spec_mix.inputs[0])
    links.new(fresnel.outputs[0], rim_map.inputs[0])
    links.new(rim_map.outputs[0], rim_mix.inputs[0])
    links.new(mix_color.outputs[0], add_rim.inputs[1])
    links.new(ramp.outputs[0], mix_color.inputs[2])
    links.new(rim_mix.outputs[0], add_rim.inputs[2])
    links.new(add_rim.outputs[0], add_spec.inputs[1])
    links.new(spec_mix.outputs[0], add_spec.inputs[2])
    links.new(add_spec.outputs[0], emission.inputs[0])
    light_mix = _add_light_mix(
        nodes,
        links,
        props,
        emission.outputs[0],
        base_color_socket=None,
        base_color=(*props.highlight_color, 1.0),
    )
    links.new(light_mix.outputs["Shader"], output.inputs[0])
    return mat
def create_toon_material_from_original(original_mat: bpy.types.Material, props, obj_name: str) -> bpy.types.Material:
    """元のマテリアルのテクスチャ/ベースカラーを保持しながらCycles用トゥーン化"""
    name = f"ToonMaterial_{obj_name}"
    if name in bpy.data.materials:
        mat = bpy.data.materials[name]
    else:
        mat = bpy.data.materials.new(name)
    mat.use_nodes = True
    mat.blend_method = 'OPAQUE'
    if hasattr(mat, 'shadow_method'):
        mat.shadow_method = 'OPAQUE'
    nodes = mat.node_tree.nodes
    links = mat.node_tree.links
    nodes.clear()
    base_color = (0.8, 0.8, 0.8, 1.0)
    texture_node = None
    if original_mat and original_mat.use_nodes:
        for node in original_mat.node_tree.nodes:
            if node.type == 'BSDF_PRINCIPLED':
                base_color_input = node.inputs.get("Base Color")
                if base_color_input:
                    if base_color_input.links:
                        linked_node = base_color_input.links[0].from_node
                        if linked_node.type == 'TEX_IMAGE' and linked_node.image:
                            texture_node = nodes.new("ShaderNodeTexImage")
                            texture_node.image = linked_node.image
                            texture_node.location = (-1000, 200)
                            texture_node.label = "Toon_Original_Texture"
                    else:
                        base_color = base_color_input.default_value[:]
                break
    geom = nodes.new("ShaderNodeNewGeometry")
    geom.location = (-1000, -100)
    geom.label = "Toon_Geometry"
    light_vec = nodes.new("ShaderNodeRGB")
    light_vec.location = (-1000, -350)
    light_vec.label = "Toon_LightVector"
    light_vec.outputs[0].default_value = (*props.light_direction, 1.0)
    dot = nodes.new("ShaderNodeVectorMath")
    dot.operation = 'DOT_PRODUCT'
    dot.location = (-800, -100)
    dot.label = "Toon_DotProduct"
    dot_add = nodes.new("ShaderNodeMath")
    dot_add.operation = 'ADD'
    dot_add.inputs[1].default_value = 1.0
    dot_add.location = (-600, -100)
    dot_add.label = "Toon_DotAdd"
    dot_mul = nodes.new("ShaderNodeMath")
    dot_mul.operation = 'MULTIPLY'
    dot_mul.inputs[1].default_value = 0.5
    dot_mul.location = (-400, -100)
    dot_mul.label = "Toon_DotMul"
    math_multiply = nodes.new("ShaderNodeMath")
    math_multiply.operation = 'MULTIPLY'
    math_multiply.inputs[1].default_value = props.light_boost
    math_multiply.location = (-150, -100)
    math_multiply.label = "Toon_LightBoost"
    math_hardness = nodes.new("ShaderNodeMapRange")
    math_hardness.data_type = 'FLOAT'
    math_hardness.interpolation_type = 'LINEAR'
    math_hardness.location = (100, -100)
    math_hardness.label = "Toon_Hardness"
    h_val = 1.0 / max(props.shadow_hardness, 0.001)
    math_hardness.inputs[1].default_value = props.shadow_step - h_val
    math_hardness.inputs[2].default_value = props.shadow_step + h_val
    math_hardness.inputs[3].default_value = 0.0
    math_hardness.inputs[4].default_value = 1.0
    ramp = nodes.new("ShaderNodeValToRGB")
    ramp.location = (400, -100)
    ramp.label = "Toon_ColorRamp"
    update_ramp_nodes(ramp, props)
    spec_ramp = nodes.new("ShaderNodeValToRGB")
    spec_ramp.color_ramp.interpolation = 'CONSTANT'
    spec_ramp.location = (400, -350)
    spec_ramp.label = "Toon_SpecRamp"
    spec_ramp.color_ramp.elements[0].position = 1.0 - props.specular_size
    spec_ramp.color_ramp.elements[0].color = (0, 0, 0, 1)
    if len(spec_ramp.color_ramp.elements) < 2:
        spec_ramp.color_ramp.elements.new(1.0)
    spec_ramp.color_ramp.elements[1].position = 1.0 - props.specular_size + 0.001
    spec_ramp.color_ramp.elements[1].color = (1, 1, 1, 1)
    spec_mix = nodes.new("ShaderNodeMixRGB")
    spec_mix.blend_type = 'MIX'
    spec_mix.inputs[1].default_value = (0, 0, 0, 1)
    spec_mix.inputs[2].default_value = (*props.specular_color, 1.0)
    spec_mix.location = (700, -350)
    spec_mix.label = "Toon_SpecMix"
    fresnel = nodes.new("ShaderNodeFresnel")
    fresnel.location = (100, -600)
    fresnel.label = "Toon_Fresnel"
    rim_map = nodes.new("ShaderNodeMapRange")
    rim_map.data_type = 'FLOAT'
    rim_map.interpolation_type = 'LINEAR'
    rim_map.location = (350, -600)
    rim_map.label = "Toon_RimMap"
    fresnel.inputs[0].default_value = 1.45
    rim_map.inputs[1].default_value = 1.0 - props.rim_light_width
    rim_map.inputs[2].default_value = 1.0 - props.rim_light_width + 0.05
    rim_map.inputs[3].default_value = 0.0
    rim_map.inputs[4].default_value = 1.0
    rim_mix = nodes.new("ShaderNodeMixRGB")
    rim_mix.blend_type = 'MIX'
    rim_mix.inputs[1].default_value = (0, 0, 0, 1)
    rim_mix.inputs[2].default_value = (*props.rim_light_color, 1.0)
    rim_mix.location = (600, -600)
    rim_mix.label = "Toon_RimMix"
    mix_color = nodes.new("ShaderNodeMixRGB")
    mix_color.blend_type = 'MULTIPLY'
    mix_color.inputs[0].default_value = props.shadow_strength
    mix_color.location = (600, 0)
    mix_color.label = "Toon_Mix"
    add_rim = nodes.new("ShaderNodeMixRGB")
    add_rim.blend_type = 'ADD'
    add_rim.inputs[0].default_value = props.rim_light_strength if props.use_rim_light else 0.0
    add_rim.location = (800, -100)
    add_rim.label = "Toon_AddRim"
    add_spec = nodes.new("ShaderNodeMixRGB")
    add_spec.blend_type = 'ADD'
    add_spec.inputs[0].default_value = 1.0 if props.use_specular else 0.0
    add_spec.location = (1000, 0)
    add_spec.label = "Toon_AddSpec"
    emission = nodes.new("ShaderNodeEmission")
    emission.inputs[1].default_value = 1.0
    emission.location = (1200, 0)
    emission.label = "Toon_Emission"
    output = nodes.new("ShaderNodeOutputMaterial")
    output.location = (1600, 0)
    links.new(geom.outputs["Normal"], dot.inputs[0])
    links.new(light_vec.outputs[0], dot.inputs[1])
    links.new(dot.outputs["Value"], dot_add.inputs[0])
    links.new(dot_add.outputs[0], dot_mul.inputs[0])
    links.new(dot_mul.outputs[0], math_multiply.inputs[0])
    links.new(math_multiply.outputs[0], math_hardness.inputs[0])
    links.new(math_hardness.outputs[0], ramp.inputs[0])
    links.new(dot_mul.outputs[0], spec_ramp.inputs[0])
    links.new(spec_ramp.outputs[0], spec_mix.inputs[0])
    links.new(fresnel.outputs[0], rim_map.inputs[0])
    links.new(rim_map.outputs[0], rim_mix.inputs[0])
    if texture_node:
        links.new(texture_node.outputs[0], mix_color.inputs[1])
    else:
        mix_color.inputs[1].default_value = base_color
    links.new(ramp.outputs[0], mix_color.inputs[2])
    links.new(mix_color.outputs[0], add_rim.inputs[1])
    links.new(rim_mix.outputs[0], add_rim.inputs[2])
    links.new(add_rim.outputs[0], add_spec.inputs[1])
    links.new(spec_mix.outputs[0], add_spec.inputs[2])
    links.new(add_spec.outputs[0], emission.inputs[0])
    light_mix = _add_light_mix(
        nodes,
        links,
        props,
        emission.outputs[0],
        base_color_socket=texture_node.outputs[0] if texture_node else None,
        base_color=base_color,
    )
    links.new(light_mix.outputs["Shader"], output.inputs[0])
    return mat
def rebuild_toon_material(mat: bpy.types.Material, props, base_color=(0.8, 0.8, 0.8, 1.0), image=None):
    """既存マテリアルをCycles用トゥーンノードで再構築"""
    mat.use_nodes = True
    mat.blend_method = 'OPAQUE'
    if hasattr(mat, 'shadow_method'):
        mat.shadow_method = 'OPAQUE'
    nodes = mat.node_tree.nodes
    links = mat.node_tree.links
    nodes.clear()
    texture_node = None
    if image:
        texture_node = nodes.new("ShaderNodeTexImage")
        texture_node.image = image
        texture_node.location = (-1000, 200)
        texture_node.label = "Toon_Original_Texture"
    else:
        if (base_color[0] + base_color[1] + base_color[2]) < 0.01:
            base_color = (*props.highlight_color, 1.0)
    geom = nodes.new("ShaderNodeNewGeometry")
    geom.location = (-1000, -100)
    geom.label = "Toon_Geometry"
    light_vec = nodes.new("ShaderNodeRGB")
    light_vec.location = (-1000, -350)
    light_vec.label = "Toon_LightVector"
    light_vec.outputs[0].default_value = (*props.light_direction, 1.0)
    dot = nodes.new("ShaderNodeVectorMath")
    dot.operation = 'DOT_PRODUCT'
    dot.location = (-800, -100)
    dot.label = "Toon_DotProduct"
    dot_add = nodes.new("ShaderNodeMath")
    dot_add.operation = 'ADD'
    dot_add.inputs[1].default_value = 1.0
    dot_add.location = (-600, -100)
    dot_add.label = "Toon_DotAdd"
    dot_mul = nodes.new("ShaderNodeMath")
    dot_mul.operation = 'MULTIPLY'
    dot_mul.inputs[1].default_value = 0.5
    dot_mul.location = (-400, -100)
    dot_mul.label = "Toon_DotMul"
    math_multiply = nodes.new("ShaderNodeMath")
    math_multiply.operation = 'MULTIPLY'
    math_multiply.inputs[1].default_value = props.light_boost
    math_multiply.location = (-150, -100)
    math_multiply.label = "Toon_LightBoost"
    math_hardness = nodes.new("ShaderNodeMapRange")
    math_hardness.data_type = 'FLOAT'
    math_hardness.interpolation_type = 'LINEAR'
    math_hardness.location = (100, -100)
    math_hardness.label = "Toon_Hardness"
    h_val = 1.0 / max(props.shadow_hardness, 0.001)
    math_hardness.inputs[1].default_value = props.shadow_step - h_val
    math_hardness.inputs[2].default_value = props.shadow_step + h_val
    math_hardness.inputs[3].default_value = 0.0
    math_hardness.inputs[4].default_value = 1.0
    ramp = nodes.new("ShaderNodeValToRGB")
    ramp.location = (400, -100)
    ramp.label = "Toon_ColorRamp"
    update_ramp_nodes(ramp, props)
    spec_ramp = nodes.new("ShaderNodeValToRGB")
    spec_ramp.color_ramp.interpolation = 'CONSTANT'
    spec_ramp.location = (400, -350)
    spec_ramp.label = "Toon_SpecRamp"
    spec_ramp.color_ramp.elements[0].position = 1.0 - props.specular_size
    spec_ramp.color_ramp.elements[0].color = (0, 0, 0, 1)
    if len(spec_ramp.color_ramp.elements) < 2:
        spec_ramp.color_ramp.elements.new(1.0)
    spec_ramp.color_ramp.elements[1].position = 1.0 - props.specular_size + 0.001
    spec_ramp.color_ramp.elements[1].color = (1, 1, 1, 1)
    spec_mix = nodes.new("ShaderNodeMixRGB")
    spec_mix.blend_type = 'MIX'
    spec_mix.inputs[1].default_value = (0, 0, 0, 1)
    spec_mix.inputs[2].default_value = (*props.specular_color, 1.0)
    spec_mix.location = (700, -350)
    spec_mix.label = "Toon_SpecMix"
    fresnel = nodes.new("ShaderNodeFresnel")
    fresnel.location = (100, -600)
    fresnel.label = "Toon_Fresnel"
    rim_map = nodes.new("ShaderNodeMapRange")
    rim_map.data_type = 'FLOAT'
    rim_map.interpolation_type = 'LINEAR'
    rim_map.location = (350, -600)
    rim_map.label = "Toon_RimMap"
    fresnel.inputs[0].default_value = 1.45
    rim_map.inputs[1].default_value = 1.0 - props.rim_light_width
    rim_map.inputs[2].default_value = 1.0 - props.rim_light_width + 0.05
    rim_map.inputs[3].default_value = 0.0
    rim_map.inputs[4].default_value = 1.0
    rim_mix = nodes.new("ShaderNodeMixRGB")
    rim_mix.blend_type = 'MIX'
    rim_mix.inputs[1].default_value = (0, 0, 0, 1)
    rim_mix.inputs[2].default_value = (*props.rim_light_color, 1.0)
    rim_mix.location = (600, -600)
    rim_mix.label = "Toon_RimMix"
    mix_color = nodes.new("ShaderNodeMixRGB")
    mix_color.blend_type = 'MULTIPLY'
    mix_color.inputs[0].default_value = props.shadow_strength
    mix_color.location = (600, 0)
    mix_color.label = "Toon_Mix"
    add_rim = nodes.new("ShaderNodeMixRGB")
    add_rim.blend_type = 'ADD'
    add_rim.inputs[0].default_value = props.rim_light_strength if props.use_rim_light else 0.0
    add_rim.location = (800, -100)
    add_rim.label = "Toon_AddRim"
    add_spec = nodes.new("ShaderNodeMixRGB")
    add_spec.blend_type = 'ADD'
    add_spec.inputs[0].default_value = 1.0 if props.use_specular else 0.0
    add_spec.location = (1000, 0)
    add_spec.label = "Toon_AddSpec"
    emission = nodes.new("ShaderNodeEmission")
    emission.inputs[1].default_value = 1.0
    emission.location = (1200, 0)
    emission.label = "Toon_Emission"
    output = nodes.new("ShaderNodeOutputMaterial")
    output.location = (1600, 0)
    links.new(geom.outputs["Normal"], dot.inputs[0])
    links.new(light_vec.outputs[0], dot.inputs[1])
    links.new(dot.outputs["Value"], dot_add.inputs[0])
    links.new(dot_add.outputs[0], dot_mul.inputs[0])
    links.new(dot_mul.outputs[0], math_multiply.inputs[0])
    links.new(math_multiply.outputs[0], math_hardness.inputs[0])
    links.new(math_hardness.outputs[0], ramp.inputs[0])
    links.new(dot_mul.outputs[0], spec_ramp.inputs[0])
    links.new(spec_ramp.outputs[0], spec_mix.inputs[0])
    links.new(fresnel.outputs[0], rim_map.inputs[0])
    links.new(rim_map.outputs[0], rim_mix.inputs[0])
    if texture_node:
        links.new(texture_node.outputs[0], mix_color.inputs[1])
    else:
        mix_color.inputs[1].default_value = base_color
    links.new(ramp.outputs[0], mix_color.inputs[2])
    links.new(mix_color.outputs[0], add_rim.inputs[1])
    links.new(rim_mix.outputs[0], add_rim.inputs[2])
    links.new(add_rim.outputs[0], add_spec.inputs[1])
    links.new(spec_mix.outputs[0], add_spec.inputs[2])
    links.new(add_spec.outputs[0], emission.inputs[0])
    light_mix = _add_light_mix(
        nodes,
        links,
        props,
        emission.outputs[0],
        base_color_socket=texture_node.outputs[0] if texture_node else None,
        base_color=base_color,
    )
    links.new(light_mix.outputs["Shader"], output.inputs[0])
def insert_toon_nodes_to_material(mat: bpy.types.Material, props) -> bool:
    """既存マテリアルにCycles用トゥーンノードを挿入（非破壊）"""
    if not mat or not mat.use_nodes:
        return False
    nodes = mat.node_tree.nodes
    links = mat.node_tree.links
    for node in nodes:
        if node.label == "Toon_ColorRamp":
            return update_existing_toon_nodes(mat, props)
    principled = None
    output = None
    for node in nodes:
        if node.type == 'BSDF_PRINCIPLED':
            principled = node
        elif node.type == 'OUTPUT_MATERIAL':
            output = node
    if not principled or not output:
        return False
    original_link = None
    for link in links:
        if link.from_node == principled and link.to_node == output:
            original_link = link
            break
    if not original_link:
        return False
    links.remove(original_link)
    x_start = principled.location.x + 300
    geom = nodes.new("ShaderNodeNewGeometry")
    geom.location = (x_start, principled.location.y - 300)
    geom.label = "Toon_Geometry"
    light_vec = nodes.new("ShaderNodeRGB")
    light_vec.location = (x_start + 5, principled.location.y - 548)
    light_vec.label = "Toon_LightVector"
    light_vec.outputs[0].default_value = (*props.light_direction, 1.0)
    dot = nodes.new("ShaderNodeVectorMath")
    dot.operation = 'DOT_PRODUCT'
    dot.location = (x_start + 200, principled.location.y - 300)
    dot.label = "Toon_DotProduct"
    dot_add = nodes.new("ShaderNodeMath")
    dot_add.operation = 'ADD'
    dot_add.inputs[1].default_value = 1.0
    dot_add.location = (x_start + 400, principled.location.y - 300)
    dot_add.label = "Toon_DotAdd"
    dot_mul = nodes.new("ShaderNodeMath")
    dot_mul.operation = 'MULTIPLY'
    dot_mul.inputs[1].default_value = 0.5
    dot_mul.location = (x_start + 600, principled.location.y - 300)
    dot_mul.label = "Toon_DotMul"
    math_multiply = nodes.new("ShaderNodeMath")
    math_multiply.operation = 'MULTIPLY'
    math_multiply.inputs[1].default_value = props.light_boost
    math_multiply.location = (x_start + 1050, principled.location.y)
    math_multiply.label = "Toon_LightBoost"
    math_hardness = nodes.new("ShaderNodeMapRange")
    math_hardness.data_type = 'FLOAT'
    math_hardness.interpolation_type = 'LINEAR'
    math_hardness.location = (x_start + 1300, principled.location.y)
    math_hardness.label = "Toon_Hardness"
    h_val = 1.0 / max(props.shadow_hardness, 0.001)
    math_hardness.inputs[1].default_value = props.shadow_step - h_val
    math_hardness.inputs[2].default_value = props.shadow_step + h_val
    math_hardness.inputs[3].default_value = 0.0
    math_hardness.inputs[4].default_value = 1.0
    ramp = nodes.new("ShaderNodeValToRGB")
    ramp.location = (x_start + 1500, principled.location.y)
    ramp.label = "Toon_ColorRamp"
    update_ramp_nodes(ramp, props)
    spec_ramp = nodes.new("ShaderNodeValToRGB")
    spec_ramp.color_ramp.interpolation = 'CONSTANT'
    spec_ramp.location = (x_start + 1400, principled.location.y - 300)
    spec_ramp.label = "Toon_SpecRamp"
    spec_ramp.color_ramp.elements[0].position = 1.0 - props.specular_size
    spec_ramp.color_ramp.elements[0].color = (0, 0, 0, 1)
    if len(spec_ramp.color_ramp.elements) < 2:
        spec_ramp.color_ramp.elements.new(1.0)
    spec_ramp.color_ramp.elements[1].position = 1.0 - props.specular_size + 0.001
    spec_ramp.color_ramp.elements[1].color = (1, 1, 1, 1)
    spec_mix = nodes.new("ShaderNodeMixRGB")
    spec_mix.blend_type = 'MIX'
    spec_mix.inputs[1].default_value = (0, 0, 0, 1)
    spec_mix.inputs[2].default_value = (*props.specular_color, 1.0)
    spec_mix.location = (x_start + 1910, principled.location.y - 300)
    spec_mix.label = "Toon_SpecMix"
    fresnel = nodes.new("ShaderNodeFresnel")
    fresnel.location = (x_start + 1200, principled.location.y - 600)
    fresnel.label = "Toon_Fresnel"
    rim_map = nodes.new("ShaderNodeMapRange")
    rim_map.data_type = 'FLOAT'
    rim_map.interpolation_type = 'LINEAR'
    rim_map.location = (x_start + 1400, principled.location.y - 600)
    rim_map.label = "Toon_RimMap"
    fresnel.inputs[0].default_value = 1.45
    rim_map.inputs[1].default_value = 1.0 - props.rim_light_width
    rim_map.inputs[2].default_value = 1.0 - props.rim_light_width + 0.05
    rim_map.inputs[3].default_value = 0.0
    rim_map.inputs[4].default_value = 1.0
    rim_mix = nodes.new("ShaderNodeMixRGB")
    rim_mix.blend_type = 'MIX'
    rim_mix.inputs[1].default_value = (0, 0, 0, 1)
    rim_mix.inputs[2].default_value = (*props.rim_light_color, 1.0)
    rim_mix.location = (x_start + 1600, principled.location.y - 600)
    rim_mix.label = "Toon_RimMix"
    mix_color = nodes.new("ShaderNodeMixRGB")
    mix_color.blend_type = 'MULTIPLY'
    mix_color.inputs[0].default_value = props.shadow_strength
    mix_color.location = (x_start + 1800, principled.location.y + 300)
    mix_color.label = "Toon_Mix"
    add_rim = nodes.new("ShaderNodeMixRGB")
    add_rim.blend_type = 'ADD'
    add_rim.inputs[0].default_value = props.rim_light_strength if props.use_rim_light else 0.0
    add_rim.location = (x_start + 2045, principled.location.y + 301)
    add_rim.label = "Toon_AddRim"
    add_spec = nodes.new("ShaderNodeMixRGB")
    add_spec.blend_type = 'ADD'
    add_spec.inputs[0].default_value = 1.0 if props.use_specular else 0.0
    add_spec.location = (x_start + 2250, principled.location.y + 300)
    add_spec.label = "Toon_AddSpec"
    emission = nodes.new("ShaderNodeEmission")
    emission.inputs[1].default_value = 1.0
    emission.location = (x_start + 2450, principled.location.y + 300)
    emission.label = "Toon_Emission"
    output.location = (x_start + 2900, principled.location.y + 300)
    links.new(geom.outputs["Normal"], dot.inputs[0])
    links.new(light_vec.outputs[0], dot.inputs[1])
    links.new(dot.outputs["Value"], dot_add.inputs[0])
    links.new(dot_add.outputs[0], dot_mul.inputs[0])
    links.new(dot_mul.outputs[0], math_multiply.inputs[0])
    links.new(math_multiply.outputs[0], math_hardness.inputs[0])
    links.new(math_hardness.outputs[0], ramp.inputs[0])
    links.new(dot_mul.outputs[0], spec_ramp.inputs[0])
    links.new(spec_ramp.outputs[0], spec_mix.inputs[0])
    links.new(fresnel.outputs[0], rim_map.inputs[0])
    links.new(rim_map.outputs[0], rim_mix.inputs[0])
    if principled.inputs['Base Color'].is_linked:
        from_socket = principled.inputs['Base Color'].links[0].from_socket
        from_node = from_socket.node
        if from_node.type == 'TEX_IMAGE' and not from_node.image:
            mix_color.inputs[1].default_value = (*props.highlight_color, 1.0)
        else:
            links.new(from_socket, mix_color.inputs[1])
    else:
        base_color = principled.inputs['Base Color'].default_value
        if (base_color[0] + base_color[1] + base_color[2]) < 0.01:
            base_color = (*props.highlight_color, 1.0)
        mix_color.inputs[1].default_value = base_color
    links.new(ramp.outputs[0], mix_color.inputs[2])
    links.new(mix_color.outputs[0], add_rim.inputs[1])
    links.new(rim_mix.outputs[0], add_rim.inputs[2])
    links.new(add_rim.outputs[0], add_spec.inputs[1])
    links.new(spec_mix.outputs[0], add_spec.inputs[2])
    links.new(add_spec.outputs[0], emission.inputs[0])
    light_mix = _add_light_mix_existing(nodes, links, props, emission.outputs[0], principled)
    light_mix.location = (x_start + 2650, principled.location.y + 300)
    links.new(light_mix.outputs["Shader"], output.inputs[0])
    return True
def update_existing_toon_nodes(mat: bpy.types.Material, props) -> bool:
    """既存のトゥーンノードを更新（Cycles）"""
    if not mat or not mat.use_nodes:
        return False
    nodes = mat.node_tree.nodes
    for node in nodes:
        id_str = node.label if node.label else node.name
        if not id_str:
            continue
        ntype = node.type
        is_mix_type = ntype in {'MIX_RGB', 'MIX'}
        is_mix_node = (ntype == 'MIX')
        if "Toon_LightBoost" in id_str and ntype == 'MATH':
            node.inputs[1].default_value = props.light_boost
        elif "Toon_Hardness" in id_str:
            if ntype == 'MAP_RANGE':
                h_val = 1.0 / max(props.shadow_hardness, 0.001)
                node.inputs[1].default_value = props.shadow_step - h_val
                node.inputs[2].default_value = props.shadow_step + h_val
            elif ntype == 'MATH':
                node.inputs[1].default_value = props.shadow_hardness
        elif "Toon_Mix" in id_str and is_mix_type:
            node.inputs[0].default_value = props.shadow_strength
        elif "Toon_AddSpec" in id_str and is_mix_type:
            node.inputs[0].default_value = 1.0 if props.use_specular else 0.0
        elif "Toon_SpecMix" in id_str and is_mix_type:
            if is_mix_node:
                soc = node.inputs.get("B") or node.inputs.get("Color2") or (node.inputs[7] if len(node.inputs) > 7 else None)
                if soc:
                    soc.default_value = (*props.specular_color, 1.0)
            else:
                node.inputs[2].default_value = (*props.specular_color, 1.0)
        elif "Toon_SpecRamp" in id_str and ntype == 'VALTORGB':
            node.color_ramp.elements[0].position = 1.0 - props.specular_size
            if len(node.color_ramp.elements) > 1:
                node.color_ramp.elements[1].position = 1.0 - props.specular_size + 0.001
        elif "Toon_ColorRamp" in id_str and ntype == 'VALTORGB':
            update_ramp_nodes(node, props)
        elif "Toon_RimMap" in id_str and ntype == 'MAP_RANGE':
            node.inputs[1].default_value = 1.0 - props.rim_light_width
            node.inputs[2].default_value = 1.0 - props.rim_light_width + 0.05
        elif "Toon_RimMix" in id_str and is_mix_type:
            if is_mix_node:
                soc = node.inputs.get("B") or node.inputs.get("Color2") or (node.inputs[7] if len(node.inputs) > 7 else None)
                if soc:
                    soc.default_value = (*props.rim_light_color, 1.0)
            else:
                node.inputs[2].default_value = (*props.rim_light_color, 1.0)
        elif "Toon_AddRim" in id_str and is_mix_type:
            node.inputs[0].default_value = props.rim_light_strength if props.use_rim_light else 0.0
        elif "Toon_LightMix" in id_str and ntype == 'MIX_SHADER':
            node.inputs[0].default_value = props.cycles_light_mix
        elif "Toon_LightVector" in id_str:
            node.outputs[0].default_value = (*props.light_direction, 1.0)
    return True