"""コア - モディファイア適用"""
import bpy
def apply_inverted_hull(obj, props):
    """Inverted Hull方式を適用"""
    if obj.type != 'MESH':
        return False
    for mod in list(obj.modifiers):
        if mod.type == 'SOLIDIFY' and mod.name.startswith("ToonOutline"):
            obj.modifiers.remove(mod)
    if props.auto_material_offset:
        material_count = len(obj.data.materials)
        if material_count == 0:
            offset = 1
        else:
            has_outline = any(m and m.name.startswith("OutlineMaterial") for m in obj.data.materials)
            if has_outline:
                for i, mat in enumerate(obj.data.materials):
                    if mat and mat.name.startswith("OutlineMaterial"):
                        offset = i
                        break
                else:
                    offset = material_count
            else:
                offset = material_count
    else:
        offset = props.material_offset
    mod = obj.modifiers.new(name="ToonOutline", type='SOLIDIFY')
    mod.thickness = props.outline_width
    mod.offset = 1.0
    mod.use_flip_normals = True
    mod.material_offset = offset
    mod.use_rim = False
    if props.outline_vertex_group in obj.vertex_groups:
        mod.vertex_group = props.outline_vertex_group
    while obj.modifiers.find(mod.name) > 0:
        with bpy.context.temp_override(active_object=obj, object=obj):
            bpy.ops.object.modifier_move_up(modifier=mod.name)
    return True