"""UIパネル - メインパネルとセットアップ"""
import bpy
from bpy.types import Panel
class OMOSEN_PT_MainPanel(Panel):
    """メインパネル（適用ボタンなど）"""
    bl_label = "OMOSEN+ Toon Shader"
    bl_idname = "OMOSEN_PT_main_panel"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = 'OMOSEN+'
    def draw(self, context):
        layout = self.layout
        props = context.scene.omosen_props
        tr = bpy.app.translations.pgettext_iface
        box = layout.box()
        box.label(text=tr("Apply / Update:"), icon='MOD_SOLIDIFY')
        row = box.row(align=True)
        row.scale_y = 1.5
        row.operator("omosen.apply_to_selected", text=tr("Apply to Selected"), icon='MESH_CUBE')
        row.operator("omosen.apply_to_all", text=tr("Apply to All"), icon='SCENE_DATA')
        row = box.row()
        row.operator("omosen.remove_from_selected", text=tr("Remove from Selected"), icon='TRASH')
        row.operator("omosen.sync_from_active", text=tr("Load from Active"), icon='FILE_REFRESH')
class OMOSEN_PT_SetupPanel(Panel):
    """セットアップパネル（モード選択）"""
    bl_label = "OMOSEN+ [Basic Settings]"
    bl_idname = "OMOSEN_PT_setup_panel"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = 'OMOSEN+'
    def draw(self, context):
        layout = self.layout
        props = context.scene.omosen_props
        tr = bpy.app.translations.pgettext_iface
        layout.prop(props, "material_mode", text=tr("Mode"))
        if props.material_mode == 'SHARED':
            layout.label(text=tr("* All objects will share the same material"), icon='INFO')
        elif props.material_mode == 'PRESERVE':
             layout.label(text=tr("* Create new material while preserving textures"), icon='INFO')
        elif props.material_mode == 'INSERT':
             layout.label(text=tr("* Insert nodes into existing materials"), icon='INFO')
class OMOSEN_PT_QuickSettings(Panel):
    """クイック設定（プリセット）"""
    bl_label = "OMOSEN+ [Presets]"
    bl_idname = "OMOSEN_PT_quick_settings"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = 'OMOSEN+'
    def draw(self, context):
        layout = self.layout
        props = context.scene.omosen_props
        tr = bpy.app.translations.pgettext_iface
        row = layout.row()
        row.prop(props, "preset", text=tr("Preset"), expand=True)