"""UIパネル - レンダー設定"""
import bpy
from bpy.types import Panel
from ..core.render_engine import get_engine_display_name, get_engine_name
class OMOSEN_PT_RenderPanel(Panel):
    """レンダー設定パネル"""
    bl_label = "OMOSEN+ [Render Settings]"
    bl_idname = "OMOSEN_PT_render_panel"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = 'OMOSEN+'
    bl_options = {'DEFAULT_CLOSED'}
    def draw(self, context):
        layout = self.layout
        tr = bpy.app.translations.pgettext_iface
        engine_name = get_engine_name(context)
        engine_display = get_engine_display_name(context)
        info_box = layout.box()
        info_box.label(text=tr("Current Render Engine: {}").format(engine_display), icon='RENDER_STILL')
        if engine_name == 'CYCLES':
            info_box.label(text=tr("⚠ Cycles support is in development"), icon='INFO')
            info_box.label(text=tr("Use 'Vector Control' shading mode for Cycles"))
        box = layout.box()
        box.label(text=tr("One-click Setup:"), icon='CHECKMARK')
        box.operator("omosen.setup_render_for_toon", text=tr("Set Render to Match Viewport"), icon='RENDER_STILL')