"""OMOSEN+ Toon Shader Addon v2.0.1
Refactored with module structure.
Equipped with asset management and simplified selection-based editing.
Cycles support in development.
"""
import bpy
bl_info = {
    "name": "OMOSEN+ Toon Shader",
    "author": "Buzzlyhan",
    "version": (2, 0, 1),
    "blender": (4, 0, 0),
    "location": "View3D > Sidebar > OMOSEN+",
    "description": "An easy-to-use toon shader addon. Contact: Buzzlyhan@gmail.com",
    "warning": "License: Pending",
    "doc_url": "https://itami.info/",
    "category": "Material",
}
from .properties import OMOSEN_Properties, OMOSEN_CustomPreset
from .handlers import sun_light_sync_handler, selection_timer, ensure_timer_registered
from .core.translations import translations_dict
from .operators import (
    OMOSEN_OT_ApplyToSelected,
    OMOSEN_OT_ApplyToAll,
    OMOSEN_OT_RemoveFromSelected,
    OMOSEN_OT_CreateOutlineVertexGroup,
    OMOSEN_OT_SetupRenderForToon,
    OMOSEN_OT_CreateDrawingGPencil,
    OMOSEN_OT_ToggleLineArt,
    OMOSEN_OT_ToggleFreestyle,
    OMOSEN_OT_ExportSettings,
    OMOSEN_OT_ImportSettings,
    OMOSEN_OT_AddCustomPreset,
    OMOSEN_OT_RemoveCustomPreset,
    OMOSEN_OT_ApplyCustomPreset,
    OMOSEN_OT_SyncFromActive,
    OMOSEN_OT_ResetSettings,
    OMOSEN_OT_ClearPresets,
)
from .ui import (
    OMOSEN_PT_MainPanel,
    OMOSEN_PT_SetupPanel,
    OMOSEN_PT_QuickSettings,
    OMOSEN_PT_OutlinePanel,
    OMOSEN_PT_EdgeLinePanel,
    OMOSEN_PT_ShadingPanel,
    OMOSEN_PT_RenderPanel,
    OMOSEN_PT_SettingsPanel,
    OMOSEN_UL_PresetList,
)
classes = (
    OMOSEN_CustomPreset,
    OMOSEN_Properties,
    OMOSEN_OT_ApplyToSelected,
    OMOSEN_OT_ApplyToAll,
    OMOSEN_OT_RemoveFromSelected,
    OMOSEN_OT_CreateOutlineVertexGroup,
    OMOSEN_OT_SetupRenderForToon,
    OMOSEN_OT_CreateDrawingGPencil,
    OMOSEN_OT_ToggleLineArt,
    OMOSEN_OT_ToggleFreestyle,
    OMOSEN_OT_ExportSettings,
    OMOSEN_OT_ImportSettings,
    OMOSEN_OT_AddCustomPreset,
    OMOSEN_OT_RemoveCustomPreset,
    OMOSEN_OT_ApplyCustomPreset,
    OMOSEN_OT_SyncFromActive,
    OMOSEN_OT_ResetSettings,
    OMOSEN_OT_ClearPresets,
    OMOSEN_PT_MainPanel,
    OMOSEN_PT_SettingsPanel,
    OMOSEN_PT_SetupPanel,
    OMOSEN_PT_QuickSettings,
    OMOSEN_PT_OutlinePanel,
    OMOSEN_PT_EdgeLinePanel,
    OMOSEN_PT_ShadingPanel,
    OMOSEN_PT_RenderPanel,
    OMOSEN_UL_PresetList,
)
def register():
    """アドオンの登録"""
    bpy.app.translations.register(__name__, translations_dict)
    for cls in classes:
        try:
            bpy.utils.register_class(cls)
        except RuntimeError:
            pass
    bpy.types.Scene.omosen_props = bpy.props.PointerProperty(type=OMOSEN_Properties)
    from .core.io import load_custom_presets
    try:
        load_custom_presets(bpy.context)
    except:
        pass
    if not bpy.app.timers.is_registered(selection_timer):
        bpy.app.timers.register(selection_timer)
        print("[OMOSEN+] Selection timer registered")
    if ensure_timer_registered not in bpy.app.handlers.load_post:
        bpy.app.handlers.load_post.append(ensure_timer_registered)
        print("[OMOSEN+] Timer check handler registered")
def unregister():
    """アドオンの登録解除"""
    if bpy.app.timers.is_registered(selection_timer):
        bpy.app.timers.unregister(selection_timer)
    if ensure_timer_registered in bpy.app.handlers.load_post:
        bpy.app.handlers.load_post.remove(ensure_timer_registered)
    if sun_light_sync_handler in bpy.app.handlers.depsgraph_update_post:
        bpy.app.handlers.depsgraph_update_post.remove(sun_light_sync_handler)
    for cls in reversed(classes):
        try:
            bpy.utils.unregister_class(cls)
        except:
            pass
    if hasattr(bpy.types.Scene, "omosen_props"):
        del bpy.types.Scene.omosen_props
    bpy.app.translations.unregister(__name__)
if __name__ == "__main__":
    register()