"""UIパネル - 詳細設定（アウトライン、エッジライン、シェーディング）"""
import bpy
from bpy.types import Panel
from ..core.render_engine import get_engine_name
class OMOSEN_PT_OutlinePanel(Panel):
    """アウトライン設定パネル"""
    bl_label = "OMOSEN+ [Outline Settings]"
    bl_idname = "OMOSEN_PT_outline_panel"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = 'OMOSEN+'
    bl_options = {'DEFAULT_CLOSED'}
    def draw(self, context):
        layout = self.layout
        props = context.scene.omosen_props
        tr = bpy.app.translations.pgettext_iface
        engine_name = get_engine_name(context)
        engine_name = get_engine_name(context)
        engine_name = get_engine_name(context)
        layout.use_property_split = True
        layout.use_property_decorate = False
        layout.prop(props, "outline_width", text=tr("Thickness"))
        layout.prop(props, "outline_color", text=tr("Color"))
        layout.separator()
        box = layout.box()
        box.label(text=tr("Outline Offset"), icon='MATERIAL')
        box.prop(props, "auto_material_offset", text=tr("Auto Set"))
        box.label(text=tr("* Auto: adjusts display order automatically"), icon='INFO')
        box.label(text=tr("* Manual: use Material Offset to fix overlaps"), icon='INFO')
        if not props.auto_material_offset:
            row = box.row()
            row.prop(props, "material_offset", text=tr("Material Offset"))
            box.label(text=tr("* Adjust when multiple materials exist"), icon='INFO')
        layout.separator()
        box = layout.box()
        box.label(text=tr("Line Thickness Adjustment"), icon='GROUP_VERTEX')
        box.prop(props, "outline_vertex_group", text=tr("Vertex Group"))
        box.operator("omosen.create_outline_vertex_group", icon='ADD')
        box.label(text=tr("* After creation, adjust thickness via Weight Paint"), icon='INFO')
class OMOSEN_PT_EdgeLinePanel(Panel):
    """エッジライン設定パネル"""
    bl_label = "OMOSEN+ [Inner Line Settings]"
    bl_idname = "OMOSEN_PT_edgeline_panel"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = 'OMOSEN+'
    bl_options = {'DEFAULT_CLOSED'}
    def draw(self, context):
        layout = self.layout
        props = context.scene.omosen_props
        tr = bpy.app.translations.pgettext_iface
        box = layout.box()
        box.label(text=tr("Line Drawing"), icon='GREASEPENCIL')
        row = box.row()
        row.scale_y = 1.5
        row.operator("omosen.create_drawing_gpencil", text=tr("Create Drawing Pen"), icon='GREASEPENCIL')
        box.label(text=tr("* Draw directly on the mesh surface"), icon='INFO')
        layout.separator()
        box = layout.box()
        row = box.row()
        row.prop(props, "use_line_art", text=tr("Line Art (Viewport)"))
        if props.use_line_art:
            row.operator("omosen.toggle_line_art", text="", icon='FILE_REFRESH')
        else:
            row.operator("omosen.toggle_line_art", text="", icon='PLAY')
        box.label(text=tr("* On: Line Art preview in viewport"), icon='INFO')
        if props.use_line_art:
            box.label(text=tr("Real-time Preview"), icon='HIDE_OFF')
            box.prop(props, "edge_line_thickness", text=tr("Line Thickness"))
            box.prop(props, "edge_line_color", text=tr("Line Color"))
        box = layout.box()
        row = box.row()
        row.prop(props, "use_freestyle", text=tr("Freestyle (Render)"))
        if props.use_freestyle:
            row.operator("omosen.toggle_freestyle", text="", icon='FILE_REFRESH')
        else:
            row.operator("omosen.toggle_freestyle", text="", icon='PLAY')
        box.label(text=tr("* On: Freestyle lines in final render"), icon='INFO')
        if props.use_freestyle:
            box.label(text=tr("High Quality Rendering"), icon='RENDER_STILL')
            if not props.use_line_art:
                box.prop(props, "edge_line_thickness", text=tr("Line Thickness"))
                box.prop(props, "edge_line_color", text=tr("Line Color"))
        if props.use_line_art or props.use_freestyle:
            layout.separator()
            layout.use_property_split = True
            layout.use_property_decorate = False
            layout.prop(props, "edge_line_thickness", text=tr("Line Thickness"))
            layout.prop(props, "edge_line_color", text=tr("Line Color"))
class OMOSEN_PT_ShadingPanel(Panel):
    """シェーディング設定パネル"""
    bl_label = "OMOSEN+ [Shading Settings]"
    bl_idname = "OMOSEN_PT_shading_panel"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = 'OMOSEN+'
    bl_options = {'DEFAULT_CLOSED'}
    def draw(self, context):
        layout = self.layout
        props = context.scene.omosen_props
        tr = bpy.app.translations.pgettext_iface
        engine_name = get_engine_name(context)
        layout.use_property_split = True
        layout.use_property_decorate = False
        layout.prop(props, "shading_method", text=tr("Method"))
        if props.shading_method == 'VECTOR':
            layout.prop(props, "light_direction", text=tr("Light Direction"))
            layout.prop(props, "use_sun_driver", text=tr("Sunlight Sync"))
        layout.separator()
        layout.prop(props, "shadow_levels", text=tr("Shadow steps"))
        layout.prop(props, "interpolation", text=tr("Interpolation"))
        layout.separator()
        layout.prop(props, "shadow_step", text=tr("Shadow Range"))
        layout.prop(props, "shadow_hardness", text=tr("Shadow Hardness"))
        layout.prop(props, "shadow_strength", text=tr("Shadow Strength"))
        layout.prop(props, "highlight_color", text=tr("Highlight Color"))
        layout.prop(props, "shadow_color", text=tr("Shadow Color 1"))
        if props.shadow_levels == 3:
            layout.prop(props, "shadow_color_2", text=tr("Shadow Color 2"))
        layout.prop(props, "light_boost", text=tr("Light Boost"))
        layout.label(text=tr("* Light Boost: overall light intensity"), icon='INFO')
        layout.label(text=tr("* Shadow Strength: darkness of shadows"), icon='INFO')
        if engine_name == 'CYCLES':
            layout.prop(props, "cycles_light_mix", text=tr("Light Mix (Cycles)"))
        layout.separator()
        box = layout.box()
        box.prop(props, "use_specular", text=tr("Use Specular"))
        if props.use_specular:
            box.prop(props, "specular_size", text=tr("Specular Size"))
            box.prop(props, "specular_color", text=tr("Specular Color"))
        box = layout.box()
        box.prop(props, "use_rim_light", text=tr("Use Rim Light"))
        if props.use_rim_light:
            box.prop(props, "rim_light_color", text=tr("Rim Light Color"))
            box.prop(props, "rim_light_strength", text=tr("Rim Light Strength"))
            box.prop(props, "rim_light_width", text=tr("Rim Light Width"))